# PR説明文生成ルール詳細

このドキュメントでは、Pull Request説明文を生成する際の詳細なルールを定義します。

## 1. テンプレート処理ルール

### 1.1 HTMLコメントの保持と内容の遵守

**重要**: PRテンプレートに含まれるHTMLコメント（`<!-- ... -->`）は削除せず、そのまま保持してください。

```markdown
<!-- このコメントは削除しないでください -->
## 概要
...
```

**さらに重要**: コメント内に書かれている内容に従ってください
- HTMLコメントにはPR作成者向けの案内が書かれていることが多い
- 記入例、注意事項、必須項目などが記載されている
- コメントの指示を読んで、その通りに説明文を作成する

例:
```markdown
<!-- 以下のチェックリストをすべて完了してください -->
- [x] テストを追加した
- [x] ドキュメントを更新した
```

### 1.2 テンプレート構造の維持

`.github/PULL_REQUEST_TEMPLATE.md` が存在する場合：
- テンプレートのセクション構造（見出し、箇条書き等）を維持
- 各セクションの内容を適切に埋める
- セクションの順序は変更しない
- **重要**: 勝手にMarkdownのセクション（`##`）やサブセクション（`###`）を追加しない
  - テンプレートにないセクションを追加してはいけない
  - テンプレート内の既存セクションのみを埋める

## 2. CIチェック項目の処理

### 2.1 基本方針

テンプレートにチェックボックス（`- [ ]`）が含まれる場合、**PR提出者として各項目を実際に確認**してください。

### 2.2 確認手順

1. **CIステータスの確認**
   ```bash
   gh pr checks
   ```

2. **確認できた項目**: `- [x]` にチェック
   ```markdown
   - [x] すべてのテストが通っている
   ```

   **注意**: テストが通った場合、件数や実行時間などの詳細情報は記載不要
   ```markdown
   ✅ - [x] すべてのテストが通っている
   ❌ - [x] すべてのテストが通っている（1234件のテストが456秒で通過）
   ```

3. **確認できない項目**: 理由をコメントで追記
   ```markdown
   - [ ] パフォーマンステストが通っている（環境がないため未確認）
   ```

### 2.3 CIチェックのスキップ条件

**重要**: CIチェックは基本的に完了を待つべきですが、以下の条件でスキップ可能です：

- **スキップ可能な条件**: 実行から5分以上経っても終わっていない場合のみ
- **注意事項**:
  - `dbt build`、`dbt run`、`dbt test` などは10分以上かかることもある
  - これらの長時間実行が予想される場合は、さらに待つことを検討
- **スキップ時の記載**:
  ```markdown
  - [ ] CIが完了している（実行中のため後で確認）
  ```

### 2.4 CIが失敗した場合の対応

**重要**: CIが落ちている場合、**あなた（PR提出者）の責任**です。

update pr が終わった後、以下の対応を行う必要があります：

1. **失敗原因の特定**
   ```bash
   gh pr checks
   gh run view [run-id] --log-failed
   ```

2. **修正の実施**
   - エラーログを確認
   - 原因を特定して修正
   - 必要に応じてコミット・プッシュ

3. **再確認**
   - 修正後、CIが通ることを確認
   - PRの説明文を更新（必要に応じて）

## 3. コンテキスト情報の収集と記載

### 3.1 収集する情報

以下の情報を収集し、PR説明文の「背景」または「コンテキスト」セクションに記載してください：

#### 3.1.1 Planファイル

今回のセッションに紐付くplanファイルがあれば参照します（会話中で言及されたもの）。

**重要**: planファイルはPR説明文に直接記載しない
- planファイルはコミットされないため、PRには含まれない
- 説明文を作成する際の**参考情報**として使用する
- planの内容を理解した上で、説明文に反映する

#### 3.1.2 会話中のURL

会話中でユーザーが提示したURLを収集し、関連情報として記載：

```markdown
## 関連情報

- https://example.com/docs/feature-spec
- https://github.com/owner/repo/issues/123/
```

### 3.2 記載場所

- PRテンプレートに「背景」セクションがあればそこに記載
- なければ「## 背景」または「## コンテキスト」セクションを追加

## 4. リンク形式ルール

### 4.1 禁止されている形式

以下の形式は**使用禁止**です：

```markdown
❌ PR #123
❌ #123
❌ issue #456
❌関連PR: #789
```

### 4.2 必須の形式

**フルURL形式**を使用してください：

#### Pull Request
```markdown
✅ https://github.com/owner/repo/pull/123/
✅ 関連PR https://github.com/owner/repo/pull/123/ を参照
```

#### Issue
```markdown
✅ https://github.com/owner/repo/issues/456/
✅ 関連issue https://github.com/owner/repo/issues/456/ を参照
```

### 4.3 Whitespace挿入ルール

前後に文字がある場合は、**必ず半角スペース（whitespace）を1つ挿入**してください：

```markdown
✅ 関連PR https://github.com/owner/repo/pull/123/ を参照
❌ 関連PRhttps://github.com/owner/repo/pull/123/を参照
❌ 関連PR https://github.com/owner/repo/pull/123/を参照
```

### 4.4 GitHub自動表示の活用

フルURL形式を使用すると、GitHubが自動的に以下の情報を表示します：
- PRのタイトル
- Issueのタイトル
- ステータス（open/closed/merged）

これにより、PRやIssue番号だけよりも情報が豊富になります。

## 5. 説明文生成パターン

### 5.1 テンプレートが存在する場合

`.github/PULL_REQUEST_TEMPLATE.md` が存在する場合：

1. テンプレートをコピー
2. HTMLコメントを保持
3. 各セクションを適切に埋める
4. CIチェック項目を確認・チェック
5. コンテキスト情報を追加
6. リンク形式を統一

### 5.2 テンプレートが存在しない場合

**確認方法:**
```bash
test -f .github/PULL_REQUEST_TEMPLATE.md && echo "exists" || echo "not found"
```

以下のセクションを含む説明文を生成：

```markdown
## 概要

[何をやったか]

## 背景

[修正が必要になった背景]
[planファイルやURLなどのコンテキスト情報]

## 変更内容

- [変更点1]
- [変更点2]

## 関連情報

- https://github.com/owner/repo/issues/123/
```

## 6. 注意事項

- 説明文は**必ず日本語**で記載
- 文字化けが発生した場合は、ファイルのエンコーディング（UTF-8）を確認
- `.claude_work/pr_body_draft.md` は削除せず残す（後で修正する可能性があるため）
