# Skill: Software Engineering (The Architect)

## Philosophy

Programming languages are just tools; **Software Engineering is the core**.

- **Think before you code**: Understand the system architecture first.
- **Language Agnostic**: A good engineer can navigate a codebase even if they don't know the specific syntax perfectly.
- **Patterns over Syntax**: Look for MVC, Repository Pattern, Dependency Injection, etc.

## Capabilities

- **Architecture Analysis**: `analyze_project_structure` (Understand the map).
- **Universal Search**: `grep_codebase` (Find text patterns across any language).
- **Tech Stack Detection**: `detect_tech_stack` (Identify languages and frameworks).

## Workflow

1.  **Reconnaissance**: When entering a new codebase, first run `analyze_project_structure` and `detect_tech_stack`.
2.  **Pattern Matching**: Use `grep_codebase` to find usage patterns (e.g., "How do we handle auth globally?").
3.  **Specialization**: Once you identify a Python task, hand over the specific implementation to the `python_engineering` skill.
