---
name: design-decision-framework
description: "多方案評估決策框架. Use for: (1) 面臨 3+ 技術方案時的結構化評估, (2) 架構決策時的系統化分析, (3) 防止衝動決策和技術債務累積"
type: decision
category: planning
---

# 多方案評估決策框架 (Design Decision Framework) SKILL

**版本**: v1.0
**建立日期**: 2025-01-23
**狀態**: 新建

## 概述

多方案評估決策框架是一套結構化的技術決策工具，用於在面臨多個技術方案時進行系統化評估和選擇。避免衝動決策，確保決策品質。

## 觸發條件

以下情況應使用此 Skill：

| 情境 | 識別特徵 | 強制性 |
|------|---------|--------|
| 多技術方案 | 面臨 3 個以上可行的技術方案 | 強制 |
| 架構決策 | 需要選擇設計模式或架構方案 | 建議 |
| 重大變更 | 變更可能影響多個模組 | 建議 |
| 不確定性高 | 團隊對方案沒有共識 | 建議 |

## 評估流程

### Stage 1: 方案收集

**目標**: 確保所有可行方案都被考慮

**執行步驟**:
1. 列出所有已知的技術方案
2. 搜尋是否有遺漏的替代方案
3. 確保每個方案都是可行的（有技術能力實現）

**輸出格式**:
```markdown
## 方案收集

### 方案 A: [名稱]
- 簡述: [一句話描述]
- 來源: [誰提出/從哪裡發現]

### 方案 B: [名稱]
- 簡述: [一句話描述]
- 來源: [誰提出/從哪裡發現]

### 方案 C: [名稱]
- 簡述: [一句話描述]
- 來源: [誰提出/從哪裡發現]
```

### Stage 2: 評估維度定義

**目標**: 確定評估的關鍵維度

**建議維度**:

| 維度 | 說明 | 權重範例 |
|------|------|---------|
| 實作複雜度 | 實作難度和時間 | 20% |
| 可維護性 | 未來維護成本 | 25% |
| 效能 | 執行效能影響 | 15% |
| 相容性 | 與現有系統相容 | 20% |
| 可擴展性 | 未來擴展空間 | 10% |
| 風險 | 技術風險程度 | 10% |

**輸出格式**:
```markdown
## 評估維度

| 維度 | 權重 | 說明 |
|------|------|------|
| [維度1] | [X]% | [說明] |
| [維度2] | [X]% | [說明] |
| [維度3] | [X]% | [說明] |
| **總計** | **100%** | - |
```

### Stage 3: 方案評分

**目標**: 對每個方案進行客觀評分

**評分標準**:
- 5 分: 優秀，完全滿足需求
- 4 分: 良好，大部分滿足需求
- 3 分: 中等，基本滿足需求
- 2 分: 較差，勉強滿足需求
- 1 分: 很差，難以滿足需求

**輸出格式**:
```markdown
## 方案評分

| 維度 | 權重 | 方案 A | 方案 B | 方案 C |
|------|------|--------|--------|--------|
| [維度1] | [X]% | [分數] | [分數] | [分數] |
| [維度2] | [X]% | [分數] | [分數] | [分數] |
| [維度3] | [X]% | [分數] | [分數] | [分數] |
| **加權總分** | - | **[X.X]** | **[X.X]** | **[X.X]** |

### 評分理由

#### 方案 A
- [維度1]: [分數] - [理由]
- [維度2]: [分數] - [理由]

#### 方案 B
- [維度1]: [分數] - [理由]
- [維度2]: [分數] - [理由]

#### 方案 C
- [維度1]: [分數] - [理由]
- [維度2]: [分數] - [理由]
```

### Stage 4: 風險分析

**目標**: 識別每個方案的主要風險

**輸出格式**:
```markdown
## 風險分析

### 方案 A 風險
| 風險 | 可能性 | 影響 | 緩解策略 |
|------|--------|------|---------|
| [風險1] | 高/中/低 | 高/中/低 | [策略] |
| [風險2] | 高/中/低 | 高/中/低 | [策略] |

### 方案 B 風險
| 風險 | 可能性 | 影響 | 緩解策略 |
|------|--------|------|---------|
| [風險1] | 高/中/低 | 高/中/低 | [策略] |

### 方案 C 風險
| 風險 | 可能性 | 影響 | 緩解策略 |
|------|--------|------|---------|
| [風險1] | 高/中/低 | 高/中/低 | [策略] |
```

### Stage 5: 決策和建議

**目標**: 根據評估結果做出決策

**輸出格式**:
```markdown
## 決策建議

### 推薦方案: [方案名稱]

**推薦理由**:
1. [理由1]
2. [理由2]
3. [理由3]

**執行建議**:
1. [建議1]
2. [建議2]

**預期效益**:
- [效益1]
- [效益2]

**注意事項**:
- [注意1]
- [注意2]

### 決策記錄

**決策者**: [角色/代理人]
**決策日期**: [日期]
**有效期限**: [如適用]
**複審條件**: [什麼情況下需要重新評估]
```

## 完整評估報告模板

```markdown
# 設計決策評估報告

## 決策背景
- **決策主題**: [主題]
- **決策日期**: [日期]
- **觸發原因**: [為什麼需要這個決策]
- **影響範圍**: [影響的模組/功能]

## 方案收集
[Stage 1 輸出]

## 評估維度
[Stage 2 輸出]

## 方案評分
[Stage 3 輸出]

## 風險分析
[Stage 4 輸出]

## 決策建議
[Stage 5 輸出]

## 5W1H 記錄

- **Who**: [決策者] (決策) | [執行者] (實作)
- **What**: [決策內容]
- **When**: [決策時間]
- **Where**: [影響範圍]
- **Why**: [決策理由]
- **How**: [Task Type: Planning] [執行方式]
```

## 使用指南

### 快速開始

1. 執行 `/design-decision-framework`
2. 按照五個階段逐步填寫
3. 產出完整的評估報告
4. 根據建議執行決策

### 何時使用

- 面臨 3+ 技術方案選擇
- 重大架構決策
- 團隊意見分歧
- 高風險技術選型

### 何時不使用

- 簡單的技術選擇（少於 3 個方案）
- 明顯的最佳選項
- 緊急修復（使用 `/pre-fix-eval` 代替）

## 與其他 Skill 的關係

| Skill | 關係 |
|-------|------|
| `/5w1h-decision` | 本 Skill 產出的決策應符合 5W1H 格式 |
| `/pre-fix-eval` | 錯誤修復評估使用 pre-fix-eval，不是本 Skill |
| `/ticket-create` | 決策完成後使用 ticket-create 建立執行 Ticket |

## 常見問題

### Q: 方案只有 2 個怎麼辦？
**A**: 如果只有 2 個方案，可以簡化流程。但建議思考是否還有第三個方案（如「維持現狀」或「延後決策」）。

### Q: 評估維度應該有幾個？
**A**: 建議 4-6 個維度。太少無法全面評估，太多會過於複雜。

### Q: 評分主觀怎麼辦？
**A**: 所有評分都應該附帶理由。理由越具體，評分越客觀。如果可能，使用量化指標支持評分。

---

**Last Updated**: 2025-01-23
**Version**: 1.0.0
