---
name: dispatch-strategy-review
description: "派發策略檢討工具. Use for: (1) 失敗數超預期 30% 時的策略檢討, (2) 重複分派失敗的分析, (3) 代理人選擇錯誤的修正"
type: review
category: quality-assurance
---

# 派發策略檢討 (Dispatch Strategy Review) SKILL

**版本**: v1.0
**建立日期**: 2025-01-23
**狀態**: 新建

## 概述

派發策略檢討工具用於檢討和改進代理人派發策略，在派發失敗或效果不佳時進行系統性分析和調整。

## 觸發條件

以下情況應使用此 Skill：

| 情境 | 識別特徵 | 強制性 |
|------|---------|--------|
| 失敗數超預期 | 失敗數超過預期的 30% | 強制 |
| 重複分派失敗 | 同一任務分派 2+ 次仍失敗 | 強制 |
| 代理人選擇錯誤 | 派發後發現代理人不適合 | 建議 |
| 效率低下 | 任務完成時間遠超預期 | 建議 |

## 檢討流程

### Stage 1: 失敗情況收集

**目標**: 收集所有派發失敗的詳細資訊

**收集項目**:
- 失敗的任務清單
- 派發的代理人
- 失敗原因
- 失敗時間

**輸出格式**:
```markdown
## 失敗情況收集

### 失敗任務清單

| # | 任務描述 | 派發代理人 | 失敗原因 | 時間 |
|---|---------|-----------|---------|------|
| 1 | [任務1] | [代理人] | [原因] | [時間] |
| 2 | [任務2] | [代理人] | [原因] | [時間] |
| 3 | [任務3] | [代理人] | [原因] | [時間] |

### 統計摘要
- **總任務數**: [數量]
- **失敗數**: [數量]
- **失敗率**: [百分比]
- **預期失敗率**: [百分比]
- **超出幅度**: [百分比]
```

### Stage 2: 失敗模式分析

**目標**: 識別失敗的共同模式

**分析維度**:

| 分析維度 | 問題 |
|---------|------|
| 代理人選擇 | 是否選錯代理人？ |
| 任務定義 | 任務描述是否清楚？ |
| 前置條件 | 是否缺少必要的前置工作？ |
| 技術能力 | 代理人是否具備必要技能？ |
| 資訊完整 | 是否提供足夠資訊？ |

**輸出格式**:
```markdown
## 失敗模式分析

### 模式識別

| 模式類型 | 出現次數 | 佔比 | 代表案例 |
|---------|---------|------|---------|
| 代理人選擇錯誤 | [N] | [X]% | [案例] |
| 任務定義不清 | [N] | [X]% | [案例] |
| 前置條件缺失 | [N] | [X]% | [案例] |
| 技術能力不足 | [N] | [X]% | [案例] |
| 資訊不完整 | [N] | [X]% | [案例] |

### 主要失敗原因

1. **[原因1]** ([X]%)
   - 詳細說明: [說明]
   - 影響任務: [任務列表]

2. **[原因2]** ([X]%)
   - 詳細說明: [說明]
   - 影響任務: [任務列表]
```

### Stage 3: 根本原因分析

**目標**: 找出導致失敗模式的根本原因

**5 Why 分析法**:
```
為什麼失敗？→ 因為 [原因1]
為什麼 [原因1]？→ 因為 [原因2]
為什麼 [原因2]？→ 因為 [原因3]
為什麼 [原因3]？→ 因為 [原因4]
為什麼 [原因4]？→ 因為 [根本原因]
```

**輸出格式**:
```markdown
## 根本原因分析

### 5 Why 分析

**失敗模式**: [模式名稱]

1. 為什麼失敗？
   → [原因1]

2. 為什麼 [原因1]？
   → [原因2]

3. 為什麼 [原因2]？
   → [原因3]

4. 為什麼 [原因3]？
   → [原因4]

5. 為什麼 [原因4]？
   → **[根本原因]**

### 根本原因總結

| 失敗模式 | 根本原因 | 可修正性 |
|---------|---------|---------|
| [模式1] | [根本原因] | 高/中/低 |
| [模式2] | [根本原因] | 高/中/低 |
```

### Stage 4: 改進策略制定

**目標**: 制定具體的改進措施

**改進維度**:

| 維度 | 改進方向 |
|------|---------|
| 派發規則 | 更新代理人選擇規則 |
| 任務模板 | 改進任務描述模板 |
| 前置檢查 | 增加前置條件檢查 |
| 代理人能力 | 更新代理人能力描述 |
| 資訊收集 | 改進資訊收集流程 |

**輸出格式**:
```markdown
## 改進策略

### 短期改進（立即執行）

| # | 改進措施 | 負責人 | 預期效果 | 執行期限 |
|---|---------|--------|---------|---------|
| 1 | [措施1] | [負責人] | [效果] | [期限] |
| 2 | [措施2] | [負責人] | [效果] | [期限] |

### 中期改進（1-2 週內）

| # | 改進措施 | 負責人 | 預期效果 | 執行期限 |
|---|---------|--------|---------|---------|
| 1 | [措施1] | [負責人] | [效果] | [期限] |
| 2 | [措施2] | [負責人] | [效果] | [期限] |

### 長期改進（規則/流程更新）

| # | 改進措施 | 影響範圍 | 預期效果 |
|---|---------|---------|---------|
| 1 | [措施1] | [範圍] | [效果] |
| 2 | [措施2] | [範圍] | [效果] |
```

### Stage 5: 監控和驗證

**目標**: 確保改進措施有效

**輸出格式**:
```markdown
## 監控和驗證計畫

### 監控指標

| 指標 | 當前值 | 目標值 | 監控頻率 |
|------|--------|--------|---------|
| 派發成功率 | [X]% | [Y]% | [頻率] |
| 重複派發率 | [X]% | [Y]% | [頻率] |
| 平均完成時間 | [X] | [Y] | [頻率] |

### 驗證檢查點

| 檢查點 | 時間 | 驗證內容 | 通過標準 |
|--------|------|---------|---------|
| [檢查1] | [時間] | [內容] | [標準] |
| [檢查2] | [時間] | [內容] | [標準] |

### 回滾計畫

如果改進措施無效或產生負面影響：
1. [回滾步驟1]
2. [回滾步驟2]
3. [回滾步驟3]
```

## 完整檢討報告模板

```markdown
# 派發策略檢討報告

## 報告資訊
- **檢討日期**: [日期]
- **觸發原因**: [原因]
- **檢討範圍**: [範圍]

## 失敗情況收集
[Stage 1 輸出]

## 失敗模式分析
[Stage 2 輸出]

## 根本原因分析
[Stage 3 輸出]

## 改進策略
[Stage 4 輸出]

## 監控和驗證
[Stage 5 輸出]

## 5W1H 記錄

- **Who**: rosemary-project-manager (檢討者)
- **What**: 派發策略檢討
- **When**: [檢討時間]
- **Where**: [影響範圍]
- **Why**: [觸發原因]
- **How**: [Task Type: Review] 系統性分析和改進
```

## 常見派發錯誤和修正

### 錯誤 1: 代理人選擇錯誤

| 錯誤派發 | 正確派發 | 識別特徵 |
|---------|---------|---------|
| parsley → Hook 開發 | basil-hook-architect | 任務涉及 Hook 腳本 |
| parsley → 文件整合 | thyme-documentation-integrator | 任務涉及方法論整合 |
| parsley → 格式化 | mint-format-specialist | 任務涉及程式碼格式化 |
| parsley → 環境問題 | sumac-system-engineer | 錯誤為依賴/環境問題 |

### 錯誤 2: 任務定義不清

**問題**: 任務描述過於模糊
**修正**: 使用 Atomic Ticket 原則，確保「一個 Action + 一個 Target」

### 錯誤 3: 前置條件缺失

**問題**: 派發時缺少必要的前置工作
**修正**: 增加 SA 前置審查，確保系統一致性

## 與其他 Skill 的關係

| Skill | 關係 |
|-------|------|
| `/ticket-track` | 使用 ticket-track 收集失敗任務資訊 |
| `/5w1h-decision` | 改進措施應符合 5W1H 格式 |
| `/pre-fix-eval` | 如果失敗涉及錯誤修復，使用 pre-fix-eval |

---

**Last Updated**: 2025-01-23
**Version**: 1.0.0
