---
name: methodology-writing
description: "方法論撰寫指南。Use for: (1) 撰寫新方法論, (2) 改寫冗長的舊方法論, (3) 檢查方法論品質"
---

# 方法論撰寫指南

## 核心原則

### 原則一：讀者是專家

讀者已經知道方法論內容，只是忘記細節。

**你的任務**：幫讀者找回記憶，不是教導或說服。

**禁止**：
- 「這不是 XXX」反向定義
- 無關的術語和譬喻
- 說服性論述

### 原則二：30 秒電梯理論

一個方法論必須在 30 秒內可讀完。

**超出部分** → reference 到其他方法論或 SKILL

**專注於**：檢查和複習，不是完整說明

### 原則三：SKILL vs 方法論區分

| 類型 | 定位 | 內容 |
|-----|------|-----|
| **SKILL** | 完整實作指南 | 設計邏輯、實作細節、範例、錯誤處理 |
| **方法論** | 30 秒快速複習 | 核心概念、檢查清單、reference 連結 |

---

## 方法論標準結構

```markdown
# [方法論名稱]

## 核心概念
[1-2 句話定義]

## 執行步驟
1. [步驟]
2. [步驟]
3. [步驟]

## 檢查清單
- [ ] [檢查項]
- [ ] [檢查項]

## Reference
- [相關方法論]
```

**層級限制**：最多 H1 → H2 → H3，禁止 H4 以下

---

## 精簡技巧

### 刪除什麼

| 刪除對象 | 理由 |
|---------|------|
| 「XXX 不是什麼」 | 讀者知道，不需要提醒 |
| 重複的範例 | 保留 1 個代表性範例 |
| 反模式章節 | 已在正向規則中說明 |
| 冗長的背景說明 | 讀者是專家 |
| 空洞的結論 | 沒有新資訊 |

### 保留什麼

| 保留對象 | 理由 |
|---------|------|
| 核心定義（1-2 句） | 快速回憶 |
| 執行步驟（3-5 步） | 可操作 |
| 檢查清單 | 驗證完成度 |
| Reference 連結 | 深入查閱 |

### 何時 Reference 出去

- 範例程式碼超過 10 行 → reference 到 SKILL
- 理論背景 → reference 到外部文獻
- 相關流程 → reference 到其他方法論

---

## 禁止模式

### 模式一：反向定義

```markdown
❌ 禁止
### 註解不是什麼
- 不是程式碼解釋器
- 不是 API 文件
- 不是 TODO 列表

✅ 直接說
### 核心概念
註解是需求保護器，記錄業務決策和修改約束。
```

### 模式二：重複對比

```markdown
❌ 禁止（同概念講 4 次）
2.3: 選擇1 vs 選擇2
2.4: 對比表
3.3: 詳細對比
3.5: 對比總結

✅ 直接說
## Sociable vs Solitary
| 面向 | Sociable | Solitary |
|-----|----------|----------|
| Unit | Module | Class |
| Mock | 外部依賴 | 所有協作者 |
```

### 模式三：過度範例

```markdown
❌ 禁止（每個規則都有完整範例）
規則一範例：20 行程式碼
規則二範例：25 行程式碼
規則三範例：15 行程式碼

✅ 直接說
## 執行步驟
1. 判斷錯誤類型
2. 程式錯誤 → 改程式
3. 架構變更 → 先更新文件

詳細範例見 [SKILL 名稱](./path/to/skill.md)
```

---

## 改寫檢查清單

### 結構檢查

- [ ] 標題層級 ≤ 3 層（H1-H3）
- [ ] 有「核心概念」章節
- [ ] 有「執行步驟」章節
- [ ] 有「檢查清單」章節
- [ ] 有「Reference」章節

### 內容檢查

- [ ] 無「XXX 不是什麼」反向定義
- [ ] 無重複的對比表格
- [ ] 無超過 10 行的程式碼範例
- [ ] 無空洞的結論章節
- [ ] 無冗長的背景說明

### 可讀性檢查

- [ ] 30 秒內可讀完
- [ ] 專業術語無需解釋
- [ ] 檢查清單可直接使用

---

## 改寫指南

改寫舊方法論時，除了精簡內容，還需處理「引用完整性」。

### Step 1: 分析被引用情況

```bash
# 搜尋所有引用該方法論的文件
grep -r "方法論檔名" .claude/
```

建立「引用→章節」對照表：

| 引用者 | 引用次數 | 實際引用內容 |
|-------|---------|-------------|
| file-a.md | 3 次 | 第二章五層定義 |
| file-b.md | 1 次 | 第六章檢查機制 |

### Step 2: 拆分決策

**拆分標準**：

| 條件 | 決策 |
|-----|------|
| 章節可完全獨立 | 拆分為衛星文件 |
| 章節有高複用性 | 拆分為獨立方法論 |
| 章節是核心定義 | 保留在主文件 |
| 章節是範例/FAQ | 拆分或刪除 |

**是否需要 SKILL**：

- 有完整操作流程 → 建立 SKILL
- 有程式碼範例 → 移到 SKILL
- 只有概念說明 → 不需要 SKILL

### Step 3: 建立引用遷移計劃

對每個引用者判斷：

```markdown
| 引用者 | 原引用 | 新引用 | 動作 |
|-------|-------|-------|-----|
| file-a.md | 主文件 | 主文件 | 不變 |
| file-b.md | 主文件 | 衛星文件 | 更新 |
| file-c.md | 主文件 | 主文件 + 衛星 | 更新 |
```

### Step 4: 執行拆分

1. **建立衛星文件**：從主文件提取章節
2. **精簡主文件**：刪除已拆分章節，加入導航連結
3. **更新引用者**：按遷移計劃更新所有連結
4. **驗證**：確認所有引用有效

### 改寫驗證檢查清單

- [ ] 已搜尋所有引用者
- [ ] 引用遷移計劃已建立
- [ ] 衛星文件已建立（如需要）
- [ ] SKILL 已建立（如需要）
- [ ] 主文件已精簡
- [ ] 所有引用者已更新
- [ ] 所有引用有效（無斷連）

---

## 改寫後整合評估

**觸發條件**：完成 2 個以上方法論改寫後（批量改寫必須執行）

### 重疊檢測

**檢查項目**：

| 檢查項目 | 問題 | 判斷標準 |
|---------|------|---------|
| 主題重疊 | 多個方法論講同一件事？ | 核心概念相似度 > 70% |
| 職責模糊 | 讀者會困惑該看哪個？ | 使用場景無法區分 |
| 內容重複 | 相同檢查清單或步驟？ | 步驟重複 > 50% |

### 處理決策

| 情況 | 處理 | 範例 |
|-----|------|------|
| **完全重疊** | 刪除其一，更新引用 | A 和 B 講同一件事 → 刪除 B |
| **部分重疊** | 合併為一，各自精簡 | A 有 80% 和 B 重疊 → 合併 |
| **互補關係** | 保留，加入交叉引用 | A 講概念，B 講實作 → 互相 reference |
| **無重疊** | 維持現狀 | 各自獨立 |

### 整合執行步驟

1. **列出所有改寫後的方法論**
2. **兩兩比較核心概念**：相似 → 標記
3. **檢查使用場景**：相同場景 → 合併候選
4. **決策**：刪除 / 合併 / 交叉引用 / 維持
5. **執行整合**：更新所有引用
6. **驗證無斷連**

### 整合檢查清單

- [ ] 已列出所有改寫後的方法論
- [ ] 已完成兩兩重疊比較
- [ ] 重疊方法論已處理（刪除/合併/交叉引用）
- [ ] 所有引用已更新
- [ ] 無斷連驗證通過

---

## Reference

### 改寫範例

- [完整改寫範例](./references/rewrite-example.md) - error-fix-refactor-methodology.md 改寫前後對比

### 相關方法論

- [方法論改寫方法論](../../methodologies/methodology-rewriting-methodology.md) - 改寫流程（30 秒版）
- [方法論撰寫方法論](../../methodologies/methodology-writing-methodology.md) - 撰寫新方法論
- [Atomic Ticket 方法論](../../methodologies/atomic-ticket-methodology.md) - 精簡範本參考
