# 改寫範例：錯誤修復方法論

本文件展示如何將冗長的方法論精簡為 30 秒可讀的版本。

---

## 改寫對象

**檔案**：`error-fix-refactor-methodology.md`
**原始行數**：338 行
**改寫後行數**：約 60 行

---

## 問題分析

| 段落 | 行數 | 問題類型 | 處理方式 |
|-----|------|---------|---------|
| 「我們拒絕的實作方式」 | 6 行 | 反向定義 | 刪除 |
| 規則一/二/三範例 | 60 行 | 重複範例 | 合併為 1 個 |
| 「反模式」章節 | 74 行 | 重複前文內容 | 刪除 |
| 「觀測和驗證原則」 | 30 行 | 細節過多 | Reference 出去 |
| 「代理人協作流程」 | 20 行 | 屬於其他方法論 | Reference 出去 |
| 結論 | 7 行 | 空洞重複 | 刪除 |

**可刪除**：約 197 行（58%）

---

## 改寫前（摘錄問題段落）

### 問題一：反向定義

```markdown
### 我們拒絕的實作方式

- **內部曝露**：直接存取物件或類別內部元素
- **行為旁路**：繞過正常業務流程的捷徑
- **測試任意修改**：為配合程式錯誤而調整測試需求
```

**問題**：讀者是專家，知道什麼不該做，不需要提醒。

### 問題二：重複範例

原文有 3 個規則，每個規則都有 20-25 行的完整程式碼範例，內容相似度高。

### 問題三：反模式章節

```markdown
## 常見錯誤和修正

### 反模式一：測試遷就程式
[20 行程式碼]

### 反模式二：內部狀態依賴
[20 行程式碼]

### 反模式三：跳過文件檢查
[20 行程式碼]
```

**問題**：這些內容在前面「執行規則」已經說過，純粹重複。

---

## 改寫後

```markdown
# 錯誤修復方法論

## 核心原則

程式服務於測試，測試服務於需求。
修復錯誤 = 修改程式，不是修改測試。

---

## 錯誤分類

### 程式實作錯誤

測試正確，程式不符合 → **改程式**

判斷標準：
- 測試需求未變更
- 相同輸入產生錯誤輸出

### 架構變更需求

需求已變，測試需更新 → **先更新文件，再改測試**

判斷標準：
- 需求文件已更新
- 業務流程變更影響多個模組

---

## 執行步驟

**程式實作錯誤**：
1. 確認測試需求正確
2. 保持測試不變
3. 修改程式直到通過

**架構變更需求**：
1. 確認需求文件已更新
2. PM 確認變更範圍
3. 依文件調整測試
4. 修改程式

---

## 檢查清單

- [ ] 測試 100% 通過
- [ ] 沒有為配合程式錯誤而修改測試
- [ ] 架構變更已反映在需求文件
- [ ] 修改的程式碼有測試保護
- [ ] 沒有曝露內部狀態

---

## Reference

- [行為觀測標準](./behavior-first-tdd-methodology.md#觀測原則) - 公開行為 vs 內部實作
- [代理人協作](./agile-refactor-methodology.md#pm代理人) - PM/重構代理人觸發條件
- [程式碼範例](./error-fix-refactor-skill.md) - 完整的修復範例程式碼
```

---

## 改寫對照表

| 項目 | 改寫前 | 改寫後 | 變化 |
|-----|-------|-------|-----|
| 總行數 | 338 | 60 | -82% |
| 章節數 | 12 | 5 | -58% |
| 程式碼範例 | 6 個（120 行） | 0 個（reference 出去） | -100% |
| 標題層級 | H1-H4 | H1-H3 | 減少 1 層 |

---

## 改寫原則總結

1. **刪除反向定義** - 讀者知道什麼不該做
2. **合併重複內容** - 相似範例只保留 1 個
3. **Reference 細節** - 程式碼範例、理論背景移到其他文件
4. **保留檢查清單** - 這是讀者最需要的
5. **刪除空洞結論** - 沒有新資訊就不要寫
