---
name: scope-confirmation
description: "功能範圍確認工具. Use for: (1) 測試/實作/需求不一致時的範圍確認, (2) 功能邊界不清時的澄清, (3) 防止範圍蔓延"
type: confirmation
category: planning
---

# 功能範圍確認 (Scope Confirmation) SKILL

**版本**: v1.0
**建立日期**: 2025-01-23
**狀態**: 新建

## 概述

功能範圍確認工具用於在測試、實作、需求之間出現不一致時，系統性地確認和對齊功能範圍，防止範圍蔓延和混淆。

## 觸發條件

以下情況應使用此 Skill：

| 情境 | 識別特徵 | 強制性 |
|------|---------|--------|
| 三方不一致 | 測試、實作、需求三者不一致 | 強制 |
| 邊界不清 | 功能邊界定義不明確 | 強制 |
| 範圍蔓延 | 實作超出原始需求 | 建議 |
| 需求變更 | 需求發生變化但文件未同步 | 建議 |

## 確認流程

### Stage 1: 現狀收集

**目標**: 收集測試、實作、需求三方的現狀

**輸出格式**:
```markdown
## 現狀收集

### 需求文件 (docs/app-requirements-spec.md)
- **功能名稱**: [名稱]
- **功能描述**: [描述]
- **驗收標準**: [標準列表]
- **文件版本**: [版本]
- **最後更新**: [日期]

### 測試案例
- **測試檔案**: [檔案路徑]
- **測試數量**: [數量]
- **測試覆蓋**: [覆蓋的功能點]
- **Given-When-Then**: [測試意圖]

### 實作狀態
- **實作檔案**: [檔案路徑]
- **實作功能**: [已實作的功能]
- **實作版本**: [版本]
```

### Stage 2: 差異分析

**目標**: 識別三方之間的差異

**分析維度**:

| 比較對象 | 可能的差異 |
|---------|-----------|
| 需求 vs 測試 | 測試未覆蓋需求、測試超出需求 |
| 需求 vs 實作 | 實作未完成需求、實作超出需求 |
| 測試 vs 實作 | 測試失敗、測試過時 |

**輸出格式**:
```markdown
## 差異分析

### 需求 vs 測試

| 需求項目 | 測試覆蓋 | 差異說明 |
|---------|---------|---------|
| [需求1] | 是/否 | [說明] |
| [需求2] | 是/否 | [說明] |

**超出需求的測試**:
- [測試1]: [說明]
- [測試2]: [說明]

### 需求 vs 實作

| 需求項目 | 實作狀態 | 差異說明 |
|---------|---------|---------|
| [需求1] | 完成/部分/未開始 | [說明] |
| [需求2] | 完成/部分/未開始 | [說明] |

**超出需求的實作**:
- [實作1]: [說明]
- [實作2]: [說明]

### 測試 vs 實作

| 測試 | 實作支持 | 結果 | 差異說明 |
|------|---------|------|---------|
| [測試1] | 是/否 | 通過/失敗 | [說明] |
| [測試2] | 是/否 | 通過/失敗 | [說明] |
```

### Stage 3: 差異根因分析

**目標**: 找出差異產生的根本原因

**根因類型**:

| 根因類型 | 說明 | 處理方向 |
|---------|------|---------|
| 需求變更未同步 | 需求改了但文件未更新 | 更新需求文件 |
| 設計遺漏 | 設計時未考慮到 | 補充設計 |
| 實作偏離 | 實作偏離原始設計 | 修正實作或更新設計 |
| 測試過時 | 測試基於舊需求 | 更新測試 |
| 範圍蔓延 | 無意中擴大範圍 | 確認範圍並調整 |

**輸出格式**:
```markdown
## 根因分析

### 差異 1: [差異描述]
- **根因類型**: [類型]
- **詳細說明**: [說明]
- **影響範圍**: [範圍]
- **建議處理**: [處理方向]

### 差異 2: [差異描述]
- **根因類型**: [類型]
- **詳細說明**: [說明]
- **影響範圍**: [範圍]
- **建議處理**: [處理方向]
```

### Stage 4: 範圍確認

**目標**: 確認最終的功能範圍

**確認問題**:
1. 這個功能應該做什麼？（In Scope）
2. 這個功能不應該做什麼？（Out of Scope）
3. 邊界條件是什麼？
4. 例外情況如何處理？

**輸出格式**:
```markdown
## 功能範圍確認

### In Scope（應該做的）

| # | 功能項目 | 驗收標準 | 優先級 |
|---|---------|---------|--------|
| 1 | [項目1] | [標準] | P0/P1/P2 |
| 2 | [項目2] | [標準] | P0/P1/P2 |

### Out of Scope（不應該做的）

| # | 排除項目 | 排除原因 | 未來規劃 |
|---|---------|---------|---------|
| 1 | [項目1] | [原因] | [規劃] |
| 2 | [項目2] | [原因] | [規劃] |

### 邊界條件

| 條件 | 處理方式 |
|------|---------|
| [條件1] | [處理] |
| [條件2] | [處理] |

### 例外情況

| 例外 | 處理方式 |
|------|---------|
| [例外1] | [處理] |
| [例外2] | [處理] |
```

### Stage 5: 對齊行動

**目標**: 制定對齊三方的具體行動

**輸出格式**:
```markdown
## 對齊行動計畫

### 需求文件更新
- [ ] [更新項目1]
- [ ] [更新項目2]

### 測試更新
- [ ] [更新/新增/刪除測試1]
- [ ] [更新/新增/刪除測試2]

### 實作調整
- [ ] [調整項目1]
- [ ] [調整項目2]

### 執行順序
1. [步驟1]
2. [步驟2]
3. [步驟3]

### 驗證方法
- [ ] 所有測試通過
- [ ] 需求文件與實作一致
- [ ] 測試覆蓋所有需求
```

## 完整確認報告模板

```markdown
# 功能範圍確認報告

## 報告資訊
- **功能名稱**: [名稱]
- **確認日期**: [日期]
- **觸發原因**: [原因]

## 現狀收集
[Stage 1 輸出]

## 差異分析
[Stage 2 輸出]

## 根因分析
[Stage 3 輸出]

## 功能範圍確認
[Stage 4 輸出]

## 對齊行動
[Stage 5 輸出]

## 5W1H 記錄

- **Who**: [確認者] | rosemary-project-manager (審核)
- **What**: 功能範圍確認 - [功能名稱]
- **When**: [確認時間]
- **Where**: [影響範圍]
- **Why**: [觸發原因]
- **How**: [Task Type: Analysis] 系統性差異分析和範圍對齊
```

## 常見情況處理

### 情況 1: 測試失敗但實作正確

**診斷**: 測試基於舊需求
**處理**:
1. 確認當前需求
2. 更新測試以符合當前需求
3. 記錄需求變更歷史

### 情況 2: 實作超出需求

**診斷**: 範圍蔓延
**處理**:
1. 確認超出部分是否有價值
2. 如有價值，補充需求文件
3. 如無價值，移除多餘實作

### 情況 3: 需求未被測試覆蓋

**診斷**: 測試遺漏
**處理**:
1. 分析遺漏原因
2. 補充缺失的測試
3. 驗證測試覆蓋率

### 情況 4: 三方都不一致

**診斷**: 多重問題
**處理**:
1. 先確認「正確的」需求
2. 以需求為基準對齊測試和實作
3. 分步驟處理，避免混亂

## 與其他 Skill 的關係

| Skill | 關係 |
|-------|------|
| `/pre-fix-eval` | 如果差異導致測試失敗，使用 pre-fix-eval 分析 |
| `/ticket-create` | 對齊行動應建立對應 Ticket |
| `/5w1h-decision` | 範圍確認決策應符合 5W1H 格式 |

## 預防措施

### 如何預防三方不一致

1. **需求變更時同步更新測試和實作**
2. **使用 TDD 流程確保測試先行**
3. **定期執行範圍確認檢查**
4. **使用 SA 前置審查確保設計一致**

### 檢查清單

每個功能完成時，確認：
- [ ] 需求文件已更新到最新
- [ ] 所有測試通過
- [ ] 測試覆蓋所有需求項目
- [ ] 沒有超出需求的實作
- [ ] 邊界條件都有處理

---

**Last Updated**: 2025-01-23
**Version**: 1.0.0
