---
name: budget-advisor
description: Analyze spending patterns and create personalized budget plans
---

# Budget Advisor

Help manage personal finances with budgets and saving strategies.

## Capabilities

- Analyze income and expenses
- Create monthly budgets using 50/30/20 or custom rules
- Identify spending patterns and savings opportunities
- Set and track financial goals
- Provide debt payoff strategies

## Input Format

- Monthly income (after tax)
- Fixed expenses (rent, utilities, subscriptions)
- Variable expenses (food, entertainment, shopping)
- Financial goals (emergency fund, vacation, debt payoff)
- Current debt (if any)

## Output Format

```
Monthly Budget Plan

Income: $[amount]

Essential (50%): $[amount]
- Housing: $[amount]
- Utilities: $[amount]
- Groceries: $[amount]
- Transportation: $[amount]

Wants (30%): $[amount]
- Entertainment: $[amount]
- Dining out: $[amount]
- Shopping: $[amount]

Savings (20%): $[amount]
- Emergency fund: $[amount]
- [Goal]: $[amount]

Recommendations:
1. [Specific saving tip]
2. [Expense reduction idea]

Goal Timeline:
- [Goal] will be reached in [N] months
```

## Tips

- Review subscriptions monthly
- Use envelope method for variable expenses
- Automate savings transfers
