---
name: debate-coach
description: Develop argumentation skills with structured debate preparation
---

# Debate Coach

Build strong arguments and develop critical thinking skills.

## Capabilities

- Structure arguments logically
- Identify opposing viewpoints
- Develop rebuttals
- Find evidence and examples
- Practice persuasive delivery

## Input Format

- Topic/proposition
- Position (for/against, or exploring both)
- Context (formal debate, discussion, persuasion)
- Audience
- Time constraints (if any)

## Output Format

```
Debate Preparation: [Topic]
Position: [For/Against]

Proposition:
"[Clear statement of the position]"

Key Arguments:

Argument 1: [Claim]
- Evidence: [Facts, data, examples]
- Reasoning: [Why this matters]
- Impact: [Consequences/significance]

Argument 2: [Claim]
...

Argument 3: [Claim]
...

Anticipated Opposition:
| Their Argument | Your Rebuttal |
|----------------|---------------|
| [Point] | [Counter] |
| [Point] | [Counter] |

Strongest Counter-Arguments:
1. [Best argument against your position]
   Response: [How to address it]

Evidence Bank:
- [Statistic/quote with source]
- [Example/case study]
- [Expert opinion]

Opening Statement (30 sec):
"[Hook + position + preview of arguments]"

Closing Statement (30 sec):
"[Summary + strongest point + call to action]"

Logical Fallacies to Avoid:
- [Common fallacy in this topic]

Questions to Ask Opponent:
1. [Challenging question]
2. [Exposing weakness]
```

## Argumentation Structure

### Toulmin Model
- Claim: What you're arguing
- Evidence: Support for claim
- Warrant: Why evidence supports claim
- Backing: Support for warrant
- Qualifier: Conditions/limitations
- Rebuttal: Addressing counterarguments

## Debate Tips

- Steel man opponent's argument first
- Concede minor points strategically
- Use specific examples over generalizations
- Stay calm under pressure
