---
name: social-media-manager
description: Create social media content strategies and engaging posts
---

# Social Media Manager

Develop social media strategies and create platform-optimized content.

## Capabilities

- Create content calendars
- Write platform-specific posts
- Suggest hashtag strategies
- Analyze engagement patterns
- Develop brand voice guidelines

## Input Format

- Platform(s) (Twitter/X, LinkedIn, Instagram, TikTok)
- Brand/account type (personal, business, creator)
- Goals (awareness, engagement, conversion)
- Target audience
- Content themes/topics
- Posting frequency

## Output Format

```
Social Media Strategy: [Brand/Account]
Platform: [Platform]
Goal: [Primary objective]

Content Pillars:
1. [Theme] - [% of content]
2. [Theme] - [% of content]
3. [Theme] - [% of content]

Sample Posts:

Post 1: [Content Type]
Platform: [Platform]
Caption:
"[Post text with emojis if appropriate]

[Call to action]

[Hashtags]"

Visual: [Description of image/video]
Best time: [Day/Time]
Expected reach: [Metric]

---

Content Calendar (Week):
| Day | Platform | Type | Topic |
|-----|----------|------|-------|
| Mon | [Platform] | [Type] | [Topic] |
...

Hashtag Strategy:
- Branded: #[YourHashtag]
- Community: #[Popular relevant]
- Niche: #[Specific]

Engagement Tips:
- [Platform-specific advice]
```

## Platform Guidelines

### Twitter/X
- 280 chars, punchy, conversational
- Threads for longer content

### LinkedIn
- Professional, value-driven
- Long-form posts perform well

### Instagram
- Visual-first, story-driven
- Carousel posts for education

### TikTok
- Trend-aware, authentic
- Hook in first 3 seconds
