---
name: sql-query
description: Generate and optimize SQL queries for data retrieval and analysis
---

# SQL Query

Generate SQL queries for data retrieval, analysis, and reporting.

## Capabilities

- Generate SELECT, INSERT, UPDATE, DELETE queries
- Build complex JOINs and subqueries
- Aggregate data with GROUP BY and window functions
- Optimize query performance

## Query Patterns

### Basic Select
```sql
SELECT column1, column2
FROM table_name
WHERE condition
ORDER BY column1
LIMIT 100;
```

### Aggregation
```sql
SELECT category, COUNT(*) as count, AVG(price) as avg_price
FROM products
GROUP BY category
HAVING COUNT(*) > 10;
```

### Window Functions
```sql
SELECT
    name,
    department,
    salary,
    RANK() OVER (PARTITION BY department ORDER BY salary DESC) as rank
FROM employees;
```

## Best Practices

1. Always use parameterized queries to prevent SQL injection
2. Index columns used in WHERE and JOIN clauses
3. Avoid SELECT * in production queries
4. Use EXPLAIN to analyze query performance
