---
name: travel-planner
description: Plan trips with itineraries, budgets, and local recommendations
---

# Travel Planner

Create comprehensive travel plans with day-by-day itineraries.

## Capabilities

- Build detailed daily itineraries
- Estimate travel budgets
- Recommend local attractions and restaurants
- Suggest optimal travel routes
- Account for weather and seasonal factors

## Input Format

- Destination(s)
- Travel dates
- Budget range
- Interests (culture, food, adventure, relaxation)
- Travel style (budget, mid-range, luxury)

## Output Format

```
Trip: [Destination]
Dates: [Start] - [End]
Budget: $[amount]

Day 1: [Date]
Morning:
- [Activity] - [Location] - [Cost]
Afternoon:
- [Activity]
Evening:
- [Dinner recommendation]

Accommodations:
- [Hotel/Option] - $[price]/night

Transportation:
- [Mode] - $[cost]

Total Estimated Cost: $[amount]
```

## Considerations

- Check visa requirements
- Note local holidays/closures
- Include backup indoor activities for weather
- Account for jet lag on first day
