---
name: spec-writing
description: This skill should be used when the user asks to "create a spec", "write a specification", "review a spec", "update a spec", "review spec organization", "split a spec", "add a page to spec", "remove a page from spec", "move requirements between pages", "add requirements", "review requirements", "update requirements", "delete requirements", "add tests", "add test cases", "review tests", "update tests", "delete tests", or needs guidance on spec structure, formatting, or spec writing best practices.
version: 0.1.0
---

# Specification writing

This skill provides guidance for creating, reviewing, and improving technical specifications. It includes progressively-disclosed references on spec structure, formatting, requirement writing, test case design, and best practices for clear and effective specification documents.

## About specifications

Specifications define formal requirements, behaviors, and interfaces for components, systems, or processes. They serve as authoritative references for development, testing, and validation activities.

## Steps

**MANDATORY STEPS FOR ALL SPEC WRITING TASKS**

1. **Gather context** - Run `oaps skill orient spec-writing` to see available references

2. **Identify relevant references** - Review the references table from step 1 and select those matching your task

3. **Load dynamic context and references** - Run `oaps skill context spec-writing --references <names...>`

4. **Review loaded references and commands** - Read through the guidance. The **Allowed commands** table at the end of the output is authoritative for what commands can be run.

5. **Follow the workflow** - Adhere to the selected workflow's steps for structuring, writing, reviewing, or improving the specification.
