---
name: artifacts
title: Artifact identification scheme
description: Artifact prefixes (RV, CH, AN, DC, DG, EX, MK, IM, VD), numbering conventions, file structure, sidecar metadata for binary assets. Load when creating or managing spec artifacts.
commands: {}
principles:
  - Artifacts are ancillary documents about a spec, not part of the spec itself
  - Use standardized two-letter prefixes for consistent categorization
  - Timestamp prefixes ensure filesystem sorting matches chronological order
  - Text artifacts use YAML frontmatter; binary assets use sidecar metadata files
  - The artifact ID remains stable even when content is updated
best_practices:
  - Use the appropriate prefix for each artifact type (RV for reviews, CH for changes, etc.)
  - Include all required fields in frontmatter (id, type, title, status, created, author)
  - Add references to related requirements, tests, or other artifacts
  - Use sidecar .metadata.yaml files for binary assets (images, videos, diagrams)
  - Set status to draft while in progress, complete when finished
  - Use supersedes/superseded_by to track artifact evolution
checklist:
  - Artifact uses correct two-letter prefix for its type
  - Filename follows YYYYMMDDHHMMSS-PREFIX-NNNN-slug format
  - All required frontmatter fields are present and valid
  - References to requirements use valid IDs
  - Binary assets have accompanying .metadata.yaml sidecar file
  - Status reflects current state (draft, complete, superseded, retracted)
  - Alt text provided for images and screenshots
references: {}
---

# Artifact identification scheme

Artifacts are ancillary documents about a spec rather than part of the spec itself.

## Artifact prefixes

| Prefix | Name | Description |
|--------|------|-------------|
| RV | Review | Design reviews, security audits, accessibility audits, peer reviews, external reviews |
| CH | Change | Errata, amendments, corrections, clarifications post-approval |
| AN | Analysis | Impact analysis, feasibility studies, risk assessments, compliance mappings |
| DC | Decision | Spec-scoped decision records for choices within this spec |
| DG | Diagram | Architecture diagrams, sequence diagrams, flow charts, visual models |
| EX | Example | Sample implementations, code snippets, worked examples |
| MK | Mockup | Wireframes, UI mockups, design comps, prototypes |
| IM | Image | Screenshots, photos, illustrations, visual references |
| VD | Video | Screen recordings, demos, walkthroughs, tutorials |

## Artifact numbering

Artifacts are numbered sequentially within their prefix using four digits, and prefixed with a timestamp for chronological sorting:

```
YYYYMMDDHHMMSS-RV-0001-security-review.md
YYYYMMDDHHMMSS-RV-0002-accessibility-audit.md
YYYYMMDDHHMMSS-CH-0001-token-expiry-clarification.md
YYYYMMDDHHMMSS-DG-0001-auth-flow.svg
YYYYMMDDHHMMSS-IM-0001-error-screenshot.png
YYYYMMDDHHMMSS-VD-0001-auth-demo.mp4
```

The timestamp is creation time. The artifact ID (e.g., `RV-0001`) remains stable; the timestamp ensures filesystem sorting matches chronological order.

## File structure

```
.oaps/docs/specs/0001-indieauth/
  index.json
  index.md
  requirements.json
  tests.json
  history.jsonl
  artifacts/
    20240115103000-RV-0001-security-review.md
    20240118140000-RV-0002-accessibility-audit.md
    20240120091500-CH-0001-token-expiry-clarification.md
    20240122160000-AN-0001-impact-analysis.md
    20240125110000-DC-0001-token-format.md
    20240128143000-DG-0001-auth-flow.svg
    20240128143000-DG-0001-auth-flow.svg.metadata.yaml
    20240130100000-IM-0001-error-screenshot.png
    20240130100000-IM-0001-error-screenshot.png.metadata.yaml
    20240201153000-VD-0001-auth-demo.mp4
    20240201153000-VD-0001-auth-demo.mp4.metadata.yaml
```

Text artifacts (RV, CH, AN, DC, EX) use YAML frontmatter in the markdown file itself.

Binary assets (DG, IM, VD, MK) use a sidecar `.metadata.yaml` file with the same filename plus the `.metadata.yaml` extension.

## Sidecar metadata schema

For binary assets, the `.metadata.yaml` sidecar uses the same schema as frontmatter:

```yaml
id: IM-0001
type: image
subtype: screenshot
title: Token validation error message
status: complete
created: 2024-01-30T10:00:00Z
updated: null
author: developer-1
reviewers: []
references:
  - FR-0012
supersedes: null
superseded_by: null
tags:
  - ui
  - errors
summary: Screenshot showing the error message when token validation fails
image_type: screenshot
format: png
dimensions: 1920x1080
alt_text: "Error dialog displaying 'Token validation failed: expired token'"
```

The CLI generates `artifacts.json` by parsing both frontmatter (from `.md` files) and sidecar files (`.metadata.yaml`).

## Artifact metadata

Artifacts are indexed in `artifacts.json` for O(1) lookup. This file is generated by the CLI from artifact frontmatter and sidecar metadata files. Do not edit directly.

```json
{
  "artifacts": [
    {
      "id": "RV-0001",
      "type": "review",
      "subtype": "security",
      "title": "Security review of token handling",
      "created": "2024-01-15T10:30:00Z",
      "author": "external-auditor",
      "file": "artifacts/20240115103000-RV-0001-security-review.md",
      "status": "complete",
      "references": ["FR-0003", "SR-0001", "SR-0002"]
    },
    {
      "id": "IM-0001",
      "type": "image",
      "subtype": "screenshot",
      "title": "Token validation error message",
      "created": "2024-01-30T10:00:00Z",
      "author": "developer-1",
      "file": "artifacts/20240130100000-IM-0001-error-screenshot.png",
      "metadata_file": "artifacts/20240130100000-IM-0001-error-screenshot.png.metadata.yaml",
      "status": "complete",
      "references": ["FR-0012"]
    }
  ]
}
```

Rebuild with:

```
spec artifacts rebuild 0001
```

## Artifact status values

| Status | Description |
|--------|-------------|
| draft | In progress, not yet complete |
| complete | Finished, ready for reference |
| superseded | Replaced by a newer artifact |
| retracted | Withdrawn, should not be used |

## Artifact frontmatter schema

All artifact markdown files use YAML frontmatter:

```yaml
---
id: RV-0001
type: review
subtype: security
title: Security review of token handling
status: complete
created: 2024-01-15T10:30:00Z
updated: 2024-01-18T14:00:00Z
author: external-auditor
reviewers:
  - maintainer-1
  - maintainer-2
references:
  - FR-0003
  - SR-0001
  - SR-0002
supersedes: null
superseded_by: null
tags:
  - tokens
  - authentication
---
```

### Required fields

| Field | Type | Description |
|-------|------|-------------|
| id | string | Artifact identifier (e.g., `RV-0001`) |
| type | string | Matches prefix: `review`, `change`, `analysis`, `decision`, `diagram`, `example`, `mockup`, `image`, `video` |
| title | string | Human-readable title |
| status | string | One of: `draft`, `complete`, `superseded`, `retracted` |
| created | datetime | ISO 8601 creation timestamp |
| author | string | Creator identifier |

### Optional fields

| Field | Type | Description |
|-------|------|-------------|
| subtype | string | Further categorization (e.g., `security`, `design`, `accessibility` for reviews) |
| updated | datetime | Last modification timestamp |
| reviewers | list | Who reviewed/approved this artifact |
| references | list | Requirements, tests, or other artifacts this relates to |
| supersedes | string | Artifact ID this replaces |
| superseded_by | string | Artifact ID that replaced this |
| tags | list | Freeform tags for filtering |
| summary | string | Brief description for listings |
| metadata_file | string | Path to sidecar `.metadata.yaml` for binary assets (generated) |

### Type-specific fields

**Reviews (RV):**

```yaml
review_type: security | design | accessibility | peer | external
findings: 3          # Number of findings
severity: high       # Highest severity finding
```

**Changes (CH):**

```yaml
change_type: erratum | amendment | clarification
affected_requirements:
  - FR-0003
  - FR-0004
```

**Decisions (DC):**

```yaml
decision_status: proposed | accepted | rejected | deprecated
decision_date: 2024-01-25
alternatives_considered: 3
```

**Diagrams (DG):**

```yaml
diagram_type: sequence | flowchart | architecture | erd | state
format: svg | png | mermaid
source_file: diagrams/auth-flow.mermaid   # If generated
```

**Images (IM):**

```yaml
image_type: screenshot | photo | illustration | reference
format: png | jpg | webp | gif
dimensions: 1920x1080
alt_text: "Token validation error message"
source_url: https://example.com/original   # If external reference
```

**Videos (VD):**

```yaml
video_type: screencast | demo | walkthrough | tutorial
format: mp4 | webm | gif
duration: 45                    # Seconds
dimensions: 1920x1080
transcript: VD-0001-transcript.md
source_url: https://youtube.com/watch?v=...   # If hosted externally
```
