---
name: banner_text_copy
description: Generate structured banner ad copy and LinkedIn post text from landing pages and audience context. Use when user says "banner copy", "ad copy", "headline variants", "/banner_text_copy", or asks to prepare copy for banner design.
---

# Banner Text Copy Generator

**Thesis:** Generate structured banner copy combinations (headline, highlight, subheadline, stats, CTA) + LinkedIn post text for Improvado paid ads, targeting specific landing pages and audience segments, outputting an MD file consumable by `/banners_design_nb`.

**Invoke:** `/banner_text_copy`

## Workflow

```mermaid
graph LR
    Input[LP URLs + Comments] --> Fetch[Fetch LP Messaging]
    Fetch --> Research[Research: Conversion Report + Existing Copy]
    Research --> Generate[Generate 20 Combinations per LP]
    Generate --> Review[Apply Rules & Constraints]
    Review --> Output[Output MD File]
    Output --> Banners[Banner fields → /banners_design_nb]
    Output --> LinkedIn[post_text → LinkedIn Ad Copy]
```

## Input

| Parameter | Required | Description |
|-----------|----------|-------------|
| **Landing pages** | Yes | LP slugs or URLs (e.g., `ai`, `home`, `improvado-tech.com/lp/ai`) |
| **Comments** | No | Tone adjustments, focus areas, audience notes, messaging direction |

If no comments provided, use default target audience and messaging from this skill.

## Output

MD file at: `algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/docs/06_BANNER_COPY_COMBINATIONS_V2.md`

Structure: per LP, 20 combinations split into Generic (5), Creative (5), Use-Case Specific (10). Each combination includes banner fields + LinkedIn post text.

## Text Field Spec (1080x1080 Banner + LinkedIn)

| Field | Max Length | Role |
|-------|-----------|------|
| **badge** | 2-4 words | Product category label — answers "what is Improvado?" |
| **headline** | 2-6 words | Primary message, large bold text |
| **highlight** | 2-5 words | Secondary line, gradient/colored |
| **subheadline** | 10-15 words | Value expansion, supporting message |
| **cta** | 2-4 words | Button text |
| **stats** | 3 items, pipe-separated | Proof points at bottom |
| **post_text** | 30-50 words | LinkedIn ad text above the banner image |

## Copy Rules (MANDATORY)

### Badge Rules
- Badge = product category label. Answers "what is Improvado?"
- **Allowed pool:** "Marketing Intelligence Platform", "AI Marketing Analytics", "Marketing Data Platform", "AI-Powered Dashboards", "Marketing Analytics Platform", "AI-Powered Analytics", "Marketing Intelligence", "AI Analytics Platform", "AI Marketing Platform"
- **NEVER** slogans, actions, or descriptions ("The End of Manual Reporting", "Goodbye Data Chaos", "Beyond BI Tools")

### CTA Rules
- **NEVER** use "Free" — no "Try It Free", "Free Trial", "Free Consultation"
- **Preferred:** "Book a Demo", "Get a Demo"
- **Variations allowed:** "Book a Demo", "Get a Demo", "See a Demo", "Get Your Demo"

### AI Mention Rules
- Use "AI" in **~50% of combinations max**. The other half should reference the platform, Improvado, or describe capability without "AI".
- Alternatives: "Improvado", "the platform", "automated", "intelligent", describe the action directly ("builds dashboards", "connects sources").
- Applies to ALL text fields: badge, headline, highlight, subheadline, post_text.

### Headline + Highlight Rules
- Headline and highlight together form one message, read as continuous text
- Do NOT force "Short Phrase. Short Phrase." pattern everywhere — use it only where it creates rhythm (e.g., "Every Campaign. Every Metric. Live.")
- When the pattern doesn't fit, write natural flowing text split across two lines (e.g., "Your Entire Marketing Budget / on One Dashboard.")
- Avoid overly short fragments that sound choppy without reason

### Subheadline Rules
- Expands the headline value prop or adds specificity
- Do NOT repeat words already in headline/highlight
- Do NOT include generic CTA language ("Personalized Demo", "using your data") — that info is on the website

### Stats Rules
- 3 proof points separated by pipes
- Mix of numbers (500+, 90%, 3X) and short phrases (Real-time, No Code)
- Keep each stat under 20 characters

### Post Text Rules (LinkedIn)
- 2-4 sentences, ~30-50 words (up to +30% in some cases). Can be split into short paragraphs.
- Does NOT repeat banner headline — **complements** it by expanding product value.
- If banner is about dashboards → post text covers the full journey (connect sources → transform → dashboards).
- If banner is about one feature → post text zooms out to platform value.
- If banner is about a specific use case → post text explains how the platform enables that use case end-to-end.
- Tone: professional, direct, no hype. Speak to a peer, not a prospect.
- Mention "Improvado" by name in most post texts (it's the LinkedIn ad, brand awareness matters).

## Target Audience (Default)

- **Role:** Marketing Director / Head of Marketing Analytics / VP Marketing
- **Company:** Large US companies, enterprise
- **Verticals:** Retail, Ecommerce, Agency
- **Focus:** B2C
- **Care about:** Revenue, ROI, Marketing efficiency, reducing manual work

## Combination Categories

### Generic (5 per LP)
Core product value props. Platform-level messaging. What Improvado does and why it matters.

### Creative (5 per LP)
Provocative hooks, pain-point angles, competitive comparisons. Designed to stop the scroll.

### Use-Case Specific (10 per LP)
Segmented by vertical (Retail, Ecom, Agency) AND persona (Paid Specialist, Marketing Ops, CMO/VP, Head of Analytics, Marketing Director). Each combination describes a specific dashboard, report, or workflow relevant to that persona.

## LP Messaging Context

### `/lp/ai` (Dark Theme)
- Dashboards from conversation — describe what you need, get a live dashboard
- Any persona gets their own dashboard — paid specialist, marketing ops, CMO, VP
- Key angles: natural language → dashboard, replace BI tools, self-serve analytics, any metric for anyone
- Under the hood: 500+ connectors, automated transformation, governed data
- Hero: "Stop building reports. Start making decisions."
- Stats: 90% Less Time, Real-time Data, 1 Day Setup, 500+ Sources

### `/lp/home` (Light Theme)
- Connect 500+ marketing data sources, unify data, get insights
- Simplify marketing data pipeline, reduce costs
- Key angles: source consolidation, automated pipelines, no engineering, cost reduction
- Hero: "Unify Your Marketing Data. Get Actionable Insights."
- Stats: 500+ Data Sources, 90% Time Saved, 3X ROI

## Research Sources

Before generating, read these files for messaging context:
1. **Conversion report:** `algorithms/revenue_div/marketing_dpt/01_projects/claude_code_lps/ENHANCED_CONVERSION_REPORT.md`
2. **Existing copy v2:** `algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/docs/06_BANNER_COPY_COMBINATIONS_V2.md`
3. **LP pages:** Fetch `improvado-tech.com/lp/ai` and `improvado-tech.com/lp/home` for latest messaging
4. **Banner skill:** `.claude/skills/banners_design_nb/SKILL.md` for generator specs

## Example Output Format

```markdown
#### U1 — Paid Media Specialist: Campaign Dashboard
- **badge:** MARKETING ANALYTICS PLATFORM
- **headline:** Every Campaign.
- **highlight:** Every Metric. Live.
- **subheadline:** CPC, ROAS, and conversions across Meta, Google, TikTok — updated in real time.
- **cta:** Book a Demo
- **stats:** All Ad Platforms | Real-time | Drill-Down
- **post_text:** Paid media teams juggle dashboards across Meta, Google, TikTok, and a dozen more platforms. Improvado consolidates all of it — pulling campaign data automatically, harmonizing metrics, and surfacing a single live view your team can actually act on.
```

---

*Skill Version: 2.0.0*
*Last Updated: 2026-01-27*
*Changes: Added LinkedIn post_text field, AI mention rules (~50% cap), headline flow rules, post text complementarity rules*
*Created by: Claude Code*
