---
name: banners_design_nb
description: Generate Improvado marketing banner designs via HTML rendering, AI image generation (fal.ai), or Gemini batch generator. Use when user says "generate banners", "design banner", "/banners_design_nb", or asks for Google Ads creatives.
---

# Banners Design NB - AI Banner Generator

**Thesis:** Generate Improvado marketing banners using 4 generators: Google Ads Minimal (Performance Max), HTML Renderer (precise typography), fal.ai (AI image generation with FLUX/Recraft), and Gemini Batch (80 banner combinations). Playwright-based generators use HTML→PNG rendering; fal.ai uses cloud AI models.

**Invoke:** `/banners_design_nb` or `/banners-design-nb`

**Companion skill:** `/banner_text_copy` — generates structured copy (headline, highlight, subheadline, stats, CTA, LinkedIn post text) that feeds into these generators.

---

## 1. Google Ads Performance Max (Minimal Banners)

Generate minimal banners for Google Ads with only: background + headline + logo. No subtitle, no CTA button, no placeholder.

```bash
cd $PROJECT_ROOT

# Generate all 9 banners (3 sizes x 3 text variations)
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_google_ads_minimal.py --size all

# Single size
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_google_ads_minimal.py --size landscape
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_google_ads_minimal.py --size square
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_google_ads_minimal.py --size portrait

# Show text variations
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_google_ads_minimal.py --list-variations
```

### Google Ads Sizes

| Type | Dimensions | Aspect Ratio | Font Size |
|------|------------|--------------|-----------|
| Landscape | 1200x628 | 1.91:1 | 58px |
| Square | 1080x1080 | 1:1 | 72px |
| Portrait | 1080x1350 | 4:5 | 76px |

### Layout Differences

| Format | Text Position | Badge Position | Logo |
|--------|---------------|----------------|------|
| Landscape | Top left | Bottom right | Bottom left, white |
| Square | Top center | Top center (above text) | Bottom center, white |
| Portrait | Top center | Top center (above text) | Bottom center, white |

### Text Variations (3 built-in)

| ID | Badge | Headline | Highlight |
|----|-------|----------|-----------|
| v1 | AI-POWERED DASHBOARDS | Stop building reports. | Start making decisions. |
| v2 | MARKETING INTELLIGENCE | Ask a Question. | Get a Dashboard. |
| v3 | AI MARKETING ANALYTICS | Dashboards That | Build Themselves. |

**Specs doc:** `docs/07_GOOGLE_ADS_PERFORMANCE_MAX_SPECS.md`

---

## 2. HTML Renderer (1080x1080 with layouts)

For precise typography and exact LP matching. Supports badge, headline, highlight, subheadline, CTA, and a placeholder area for visuals.

```bash
# Generate banner for AI landing page (dark theme)
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_html_renderer.py --lp ai --layout A

# Generate banner for Home landing page (light theme)
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_html_renderer.py --lp home --layout B

# Custom headline
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_html_renderer.py --lp ai --headline "AI Dashboards." --highlight "Zero Manual Work."

# All 4 layouts for one LP
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_html_renderer.py --lp ai --all-layouts
```

### Layouts Reference

```
Layout A: Classic Left          Layout B: Classic Right
┌─────────────────────┐        ┌─────────────────────┐
│ TEXT    │  VISUAL   │        │ VISUAL  │   TEXT    │
│ Headline│ placeholder│        │placeholder│ Headline │
│ [CTA]   │           │        │         │   [CTA]   │
│      improvado      │        │      improvado      │
└─────────────────────┘        └─────────────────────┘

Layout C: Top Visual            Layout D: Bottom Hero
┌─────────────────────┐        ┌─────────────────────┐
│ ┌─────────────────┐ │        │      improvado      │
│ │    VISUAL       │ │        │      HEADLINE       │
│ └─────────────────┘ │        │        [CTA]        │
│     HEADLINE        │        │ ┌─────────────────┐ │
│      [CTA]          │        │ │    VISUAL       │ │
│    improvado        │        │ └─────────────────┘ │
└─────────────────────┘        └─────────────────────┘
```

---

## 3. fal.ai Image Generation (FLUX / Recraft)

Generate AI banner visuals using fal.ai models. Supports 3 models, 3 presets, 4 sizes. Best for creating visual backgrounds and creative variations that can be composited with text overlays.

```bash
# Generate with preset (ai-dark theme, square)
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_fal_ai.py --preset ai-dark --model flux-pro

# Fast iteration with schnell model
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_fal_ai.py --preset ai-dark --model flux-schnell

# Recraft V3 with brand color control
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_fal_ai.py --preset home-light --model recraft

# Custom prompt
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_fal_ai.py --prompt "Abstract data visualization with glowing nodes" --model flux-pro --size landscape

# All 4 sizes at once
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_fal_ai.py --preset ai-dark --model flux-pro --all-sizes

# List presets and models
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_fal_ai.py --list-presets
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/banner_fal_ai.py --list-models
```

### fal.ai Models

| Model | Endpoint | Best For | Speed |
|-------|----------|----------|-------|
| `flux-pro` | `fal-ai/flux-pro/v1.1` | High-quality photorealistic visuals | Medium |
| `flux-schnell` | `fal-ai/flux/schnell` | Fast iterations, prototyping | Fast |
| `recraft` | `fal-ai/recraft-v3` | Brand color control, text rendering | Medium |

### Presets

| Preset | Theme | Colors |
|--------|-------|--------|
| `ai-dark` | Dark futuristic, neural networks, data streams | `#0D0D12`, `#FF3366`, `#FFB347`, `#8B5CF6` |
| `home-light` | Clean white, professional SaaS aesthetic | `#FFFFFF`, `#7C3AED`, `#10B981`, `#FF3187` |
| `retargeting` | Deep purple, glowing mint, premium fintech | `#1E1040`, `#5EEAD4`, `#FF3187`, `#8B5CF6` |

### Sizes

| Key | Dimensions | Use Case |
|-----|------------|----------|
| `square` | 1080x1080 | Social ads, Instagram |
| `landscape` | 1200x628 | Google Ads (1.91:1) |
| `portrait` | 1080x1350 | Stories, Pinterest (4:5) |
| `wide` | 1920x1080 | Display ads (16:9) |

---

## 4. Gemini Batch Generator (v10 — 80 banners)

Full batch generator using Gemini image model. Generates ALL copy combinations from `06_BANNER_COPY_COMBINATIONS_V2.md`: 20 AI texts x 2 layouts + 20 Home texts x 2 layouts = 80 banners.

```bash
# All 80 banners
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/nanabanana_v10.py

# Just AI LP (40 banners)
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/nanabanana_v10.py --lp ai

# Just Home LP (40 banners)
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/nanabanana_v10.py --lp home

# AI layout A only (20 banners)
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/nanabanana_v10.py --lp ai --layout A

# Test single banner
venv/bin/python algorithms/revenue_div/marketing_dpt/01_projects/paid_ads/banners_development/src/nanabanana_v10.py --test
```

### Copy Categories (per LP)

| Category | IDs | Count | Description |
|----------|-----|-------|-------------|
| Generic (Dashboard-First) | G1–G5 (AI) / G6–G10 (Home) | 5 | Core product messaging |
| Creative (Emotional) | C1–C5 (AI) / C6–C10 (Home) | 5 | Bold, emotional hooks |
| Use-Case (Persona) | U1–U10 (AI) / U11–U20 (Home) | 10 | Persona-targeted pain points |

### Layouts

| Layout | Description |
|--------|-------------|
| A | Left text + right placeholder (classic) |
| F | Centered text with stats footer |

### Output Naming

`v10_{lp}_{layout}_{copy_id}_{timestamp}.png` — e.g. `v10_ai_A_G1_20260127_203752.png`

---

## Landing Pages & Themes

| LP | URL | Background | Accent / Highlight | CTA |
|----|-----|------------|-------------------|-----|
| `ai` | improvado-tech.com/lp/ai | `#0D0D12` (dark) | Pink→gold gradient `#FF3366→#FFB347` | `#FF3366` pink |
| `home` | improvado-tech.com/lp/home | `#FFFFFF` (light) | Purple `#7C3AED` | `#7C3AED` purple |

---

## Generator Comparison

| Feature | Google Ads Minimal | HTML Renderer | fal.ai (FLUX/Recraft) | Gemini v10 Batch |
|---------|-------------------|---------------|----------------------|-----------------|
| Size | 3 sizes (1200x628, 1080², 1080x1350) | 1080x1080 | 4 sizes (square, landscape, portrait, wide) | 1080x1080 |
| Typography | ★★★★★ | ★★★★★ | ★★★★☆ (Recraft) / ★★☆☆☆ (FLUX) | ★★☆☆☆ |
| Multi-size | ★★★★★ | ☆☆☆☆☆ | ★★★★★ (--all-sizes) | ☆☆☆☆☆ |
| Layout variants | 3 auto-adaptive | A/B/C/D | 3 presets + custom prompts | A / F |
| Brand color control | No | No | ★★★★★ (Recraft) | No |
| Creative variation | ★★☆☆☆ | ★★☆☆☆ | ★★★★★ (unlimited prompts) | ★★★★★ (80 combos) |
| Speed | ★★★★★ | ★★★★★ | ★★★★☆ (schnell) / ★★★☆☆ (pro) | ★★☆☆☆ (batch) |
| Requires API | No | No | Yes (fal.ai FAL_KEY) | Yes (Gemini) |

### When to Use Which

| Scenario | Generator |
|----------|-----------|
| Google Ads Performance Max campaign | Google Ads Minimal |
| Prospecting banners (feature-focused) | HTML Renderer |
| AI-generated visual backgrounds with brand colors | fal.ai (Recraft for colors, FLUX for quality) |
| Fast AI visual iterations / prototyping | fal.ai (flux-schnell) |
| Full batch of all copy combinations | Gemini v10 Batch |
| Need banner copy text first | `/banner_text_copy` → then any generator |

---

## CLI Options

### Google Ads Minimal (`banner_google_ads_minimal.py`)

| Option | Description |
|--------|-------------|
| `--size landscape\|square\|portrait\|all` | Banner size(s) to generate |
| `--list-variations` | Show text variations |

### HTML Renderer (`banner_html_renderer.py`)

| Option | Description |
|--------|-------------|
| `--lp ai\|home` | Landing page theme (default: ai) |
| `--layout A\|B\|C\|D` | Layout variant (default: A) |
| `--headline "..."` | Custom headline text |
| `--highlight "..."` | Custom highlight text |
| `--output filename` | Custom output filename |
| `--all-layouts` | Generate all 4 layouts |

### fal.ai Generator (`banner_fal_ai.py`)

| Option | Description |
|--------|-------------|
| `--prompt "..."` | Custom prompt for image generation |
| `--preset ai-dark\|home-light\|retargeting` | Use brand-consistent preset prompt |
| `--model flux-pro\|flux-schnell\|recraft` | fal.ai model (default: flux-pro) |
| `--size square\|landscape\|portrait\|wide` | Banner size (default: square) |
| `--all-sizes` | Generate all 4 sizes |
| `--suffix "..."` | Additional text to append to prompt |
| `--seed N` | Random seed for reproducibility |
| `--num-images N` | Number of images to generate (default: 1) |
| `--output filename` | Custom output filename |
| `--list-presets` | Show available presets |
| `--list-models` | Show available models |

### Gemini Batch (`nanabanana_v10.py`)

| Option | Description |
|--------|-------------|
| `--lp ai\|home` | Filter by LP (default: both) |
| `--layout A\|F` | Filter by layout (default: both) |
| `--test` | Generate one test banner |
| *(no args)* | Generate all 80 banners |

---

## Output Directories

```
banners_development/output/
├── google_ads_minimal/    # Performance Max banners (3 sizes)
│   └── batch_YYYYMMDD_HHMMSS/
├── html_banners/          # HTML renderer output (1080x1080)
├── fal_ai_banners/        # fal.ai AI-generated banners
│   └── batch_YYYYMMDD_HHMMSS/
├── v10_banners/           # Gemini batch output (80 banners)
├── assets/                # Logo files for embedded rendering
│   ├── logo_main_b64.txt
│   ├── logo_ai_b64.txt
│   ├── logo_main_color.png
│   └── logo_ai_lp.png
└── lp_screenshots/        # LP reference screenshots for Gemini
```

---

## Copy Reference Docs

| Doc | Content | Path |
|-----|---------|------|
| **V2 Copy Combinations** | 40 combinations (20 per LP): Generic, Creative, Use-Case | `docs/06_BANNER_COPY_COMBINATIONS_V2.md` |
| **Google Ads Specs** | Performance Max sizes and asset requirements | `docs/07_GOOGLE_ADS_PERFORMANCE_MAX_SPECS.md` |
| **Design Guide** | Brand colors, typography, layout rules | `docs/04_BANNER_DESIGN_GUIDE.md` |

---

## Setup

### Dependencies
```bash
venv/bin/pip install playwright pillow python-dotenv
playwright install chromium
```

### For fal.ai generators
```bash
venv/bin/pip install fal-client python-dotenv
# API key in .env: FAL_KEY=...
```

### For Gemini generators
```bash
venv/bin/pip install google-genai httpx beautifulsoup4
# API key in .env: GEMINI_API_KEY=...
```

---

## Files

```
banners_development/
├── src/
│   ├── banner_google_ads_minimal.py  # Google Ads Performance Max (3 sizes)
│   ├── banner_html_renderer.py       # HTML renderer (4 layouts, 2 themes)
│   ├── banner_fal_ai.py              # fal.ai image generation (FLUX/Recraft)
│   └── nanabanana_v10.py             # Gemini batch generator (80 banners)
├── docs/
│   ├── 04_BANNER_DESIGN_GUIDE.md
│   ├── 06_BANNER_COPY_COMBINATIONS_V2.md
│   └── 07_GOOGLE_ADS_PERFORMANCE_MAX_SPECS.md
└── output/
    ├── assets/              # Logo files (base64 + PNG)
    ├── google_ads_minimal/
    ├── html_banners/
    ├── fal_ai_banners/
    ├── v10_banners/
    └── lp_screenshots/
```

---

*Skill Version: 7.0.0*
*Last Updated: 2026-02-24*
*Changes: Removed deprecated generators (Retargeting Social Proof, SVG Renderer, Figma MCP, nanabanana v1-v9). Consolidated to 4 active generators: Google Ads Minimal, HTML Renderer, fal.ai, Gemini v10 Batch.*
