# Banners Design NB - Release Log

## v7.0.0 (2026-02-24)

**Added fal.ai image generation + removed deprecated generators.**

### Added
- New `banner_fal_ai.py` — AI-generated banner visuals via fal.ai API
  - **3 models:** FLUX Pro (photorealistic), FLUX Schnell (fast iterations), Recraft V3 (brand colors + text)
  - **3 presets:** `ai-dark`, `home-light`, `retargeting` with brand-consistent prompts
  - **4 sizes:** square, landscape, portrait, wide
  - Custom prompts, seed for reproducibility, batch generation
- Added `FAL_KEY` to `.env` (gitignored, secure)
- Installed `fal-client` package

### Removed
- `banner_retargeting_social_proof.py` — retargeting social proof generator
- `banner_svg_renderer.py` — SVG/Figma renderer
- `figma_mcp/` — entire Figma MCP integration directory
- `nanabanana_v1.py` through `nanabanana_v9.py` — legacy Gemini generators (v10 kept)
- `docs/00_banner_automation_research.md` — outdated research
- `docs/01_FIGMA_BANNER_WORKFLOW.md` — Figma workflow (no longer used)
- `docs/05_BANNER_COPY_COMBINATIONS.md` — v1 copy (replaced by v2)
- `docs/08_RETARGETING_BANNER_COPY_SOCIAL_PROOF.md` — retargeting copy
- `output/retargeting_banners/` — retargeting output directory
- `output/svg_banners/` — SVG output directory

### Result
- Consolidated from 7 generators → 4 active: Google Ads Minimal, HTML Renderer, fal.ai, Gemini v10 Batch

---

## v5.0.0 (2026-02-23)

**Full skill audit and update to match current state of all generators.**

### Changes
- Added **Retargeting Social Proof** generator section (`banner_retargeting_social_proof.py`)
  - 10 pre-built quote-centered variants (5 AI dark + 5 Home deep purple)
  - Embedded PNG logos via base64
  - Customer quotes from G2, Capterra, case studies
  - Two badge types: stars (G2 rating) and dot (customer result)
- Added **SVG Renderer** section (`banner_svg_renderer.py`)
  - Figma-editable SVG output
  - Optional PNG conversion via Playwright
- Documented **logo assets** in `output/assets/` (base64 + PNG)
- Added **companion skill reference** (`/banner_text_copy`)
- Expanded **Landing Pages & Themes** table with per-generator color differences
- Updated **Generator Comparison** matrix (5 generators now)
- Added **"When to Use Which"** decision guide
- Updated **CLI Options** for all 4 Playwright-based generators
- Updated **Output Directories** (retargeting_banners, svg_banners, assets)
- Added **Copy Reference Docs** section linking all 4 docs
- Updated **Files** tree to reflect current state

---

## v4.0.0 (2026-01-29)

**Added Google Ads Performance Max minimal generator.**

### Changes
- New `banner_google_ads_minimal.py` — 3 sizes (landscape, square, portrait) with 3 text variations = 9 banners
- Dark theme only, minimal design: background + headline + logo
- Batch output in timestamped directories

---

## v3.0.0 (2026-01-27)

**Added copy combinations v2 and batch generators.**

### Changes
- Banner Copy Combinations V2 (40 combinations across 2 LPs)
- nanabanana v5–v10 batch generators
- LP-specific generation with screenshot reference

---

## v2.0.0 (2026-01-23)

**Major restructure with multi-layout system.**

### Changes
- Restructured folder: `src/`, `docs/`, `output/`, `figma_mcp/`
- Added 4 layout variants (A/B/C/D)
- Added 3 color themes
- Fixed GEMINI_API_KEY loading from `.env`
- Saved API key to `.env` for persistence
- Created comprehensive skill documentation

### Layouts
- **A: Classic Left** - Text left, visual right
- **B: Classic Right** - Visual left, text right
- **C: Top Visual** - Visual top, text bottom
- **D: Bottom Hero** - Text top, visual bottom

### Files
```
banners_development/
├── src/
│   ├── nanabanana_v1.py    # Original generator
│   └── nanabanana_v2.py    # Multi-layout system
├── docs/                    # Design guides
├── output/
│   ├── v1_archive/         # Old banners
│   └── v2_layouts/         # New banners
└── figma_mcp/              # Figma integration
```

### API Key
- Key recovered from session `22dfb604-6fc4-4620-9dd4-bc6604afabe2`
- Saved to `.env` as `GEMINI_API_KEY`

---

## v1.0.0 (2026-01-22)

**Initial nanabanana generator.**

- Single layout (text left, visual right)
- 3 themes support
- Basic CLI and Python API
