---
name: claude-command-dispatcher
description: "Use when the user asks to run or reuse a Claude Code custom command from .claude/commands (for example '/plan', '/tasks', '/specify', '/chat_sum'). Dynamically resolves any command file in .claude/commands without hardcoded command names."
---

# Claude Command Dispatcher

Bridge skill that lets Codex execute command prompts stored in `.claude/commands/*.md`.

## When To Use

Use this skill when the user:
- references a Claude-style command like `/plan` or `/tasks`
- asks to reuse or run something from `.claude/commands`
- asks to adapt a new command that was just added there

Do not hardcode command names. Always resolve the command file dynamically.

## Execution Flow

1. Parse command name and command arguments from the user request:
- Accept both `/name ...` and `name ...`
- `name` maps to `.claude/commands/name.md`
- the rest of the text is `ARGUMENTS`

2. Resolve repository root dynamically:
```bash
git rev-parse --show-toplevel
```
If unavailable, use current working directory.

3. Build command file path:
- `<repo-root>/.claude/commands/<name>.md`

4. If file does not exist:
- list available commands with:
```bash
ls -1 <repo-root>/.claude/commands/*.md
```
- ask the user to choose a valid command name

5. Read the command markdown file and execute its instructions as the task definition:
- treat `$ARGUMENTS` placeholders as the parsed `ARGUMENTS`
- preserve instruction order from the command file
- respect referenced templates/scripts in the command instructions

6. Return results in normal Codex style:
- what was executed
- output artifacts and paths
- blockers/errors if any

## Guardrails

- Never use absolute user-specific paths in new logic.
- Prefer repository-relative paths rooted from dynamic repo root.
- If a command file itself contains absolute paths, use them only as command intent, but keep any new code generic.

