---
name: claude-task-from-obsidian
description: Execute tasks from Obsidian automation by reading task context and writing completion results back to the source file. Use when user says "execute Obsidian task", "выполни задачу из обсидиан", or prompt contains Obsidian file path plus line reference.
sentence_summary: "Execute tasks from Obsidian automation by reading file content and writing results back."
paragraph_summary: "Receives autonomous task messages containing Obsidian file references, reads task content, executes the requested work, and writes completion status with results back to the original file using session tracking."
---

# Claude Task from Obsidian

Use when agent receives message containing Obsidian file path from automation, or when user says "execute Obsidian task", "выполни задачу из обсидиан".

## Task Format in Obsidian

Tasks are bullet points with `#claude_task` tag:

```markdown
- xyops - motia alternative?
  - https://github.com/...
    - research it #claude_task        ← TASK (pending)
    - 📎 [[Claude Sessions/rc abc123]] ← Session link (added by server)
    - 🤖 **Done:** Summary of result    ← Result (added by agent)
```

## Status Tags

| Tag | When | Who Sets |
|-----|------|----------|
| `#claude_task` | Task created | User |
| `#doing` | Agent started work | Server (auto) |
| `#in-review` | Task completed | **Agent (YOU!)** |
| `#done` | User approved | User (manual) |

## CRITICAL: Complete Task Lifecycle

When you receive a task from Obsidian automation, follow this lifecycle:

### Phase 1: Understand Task

The prompt will contain:
- File path: e.g., `General Knowledge and Research/Data orchestration industry/xyops - motia alternative.md`
- Line number: e.g., `line 3`
- Task text: e.g., `research it #claude_task`

### Phase 2: Execute Task

- Understand what the task requires
- Use appropriate tools (web search, file read, code analysis, etc.)
- Keep track of what you accomplished

### Phase 3: Write Result (MANDATORY!)

After completing the task, update the Obsidian file:

```python
# Use the obsidian ops module
import sys
sys.path.insert(0, '$PROJECT_ROOT')
from data_sources.obsidian.ops.claude_tasks import add_result

# Add result (this also changes #doing -> #in-review)
add_result(
    file_path="$PROJECT_ROOT/data_sources/obsidian/vault/path/to/file.md",
    line_number=3,  # Line number from the prompt
    result_text="Brief summary of what was accomplished"
)
```

Or use MCP tool:

```python
# Patch the file via MCP
mcp__obsidian__patch_vault_file(
    filename="path/to/file.md",
    target="Task heading or block-id",
    targetType="heading",
    operation="append",
    content="- 🤖 **Done:** Brief summary of what was accomplished"
)
```

## Quick Template

When task is complete:

```python
from data_sources.obsidian.ops.claude_tasks import add_result

# Extract from prompt:
# FILE_PATH = absolute path to file
# LINE_NUMBER = task line number
# RESULT = what you accomplished

add_result(FILE_PATH, LINE_NUMBER, RESULT)
print("Task completed and result written!")
```

## Example Flow

```
1. Receive: "AUTONOMOUS MODE... Execute task from Obsidian file
   'General Knowledge/xyops.md' line 3: research it #claude_task"

2. Parse:
   - file = "General Knowledge/xyops.md"
   - line = 3
   - task = "research it"

3. Execute:
   - Search web for "xyops workflow automation"
   - Read GitHub repo
   - Analyze features

4. Complete:
   add_result(
       "/full/path/to/vault/General Knowledge/xyops.md",
       3,
       "XYOps is a lightweight YAML-based workflow framework, simpler than Motia but with fewer features"
   )

5. File now shows:
   - research it #claude_task #in-review
   - 📎 [[Claude Sessions/rc abc123]]
   - 🤖 **Done:** XYOps is a lightweight YAML-based workflow framework...
```

## Checklist Before Finishing

Before you consider the task complete, verify:

- [ ] Task requirements fulfilled
- [ ] `🤖 **Done:** summary` added to file
- [ ] Status changed from `#doing` to `#in-review`
- [ ] Stay interactive for follow-up questions (if user present)

## Related Skills

- `/obsidian-markdown` - Obsidian formatting syntax
- `/claude-code-sessions` - Session management
- `/chat_sum` - Generate session summary

---
Created: 2026-01-16 | Session: ce7d0b02-d5b7-44ae-8f2e-7196288051b2
