---
name: clickhouse-internal-analytics
description: Query ClickHouse Palantir shard (internal_analytics) for business metrics, Jira, customers. Use when user says "internal analytics", "biz_active_customers", "Palantir", "agency_id lookup". NOT for client im_XXXX data.
version: "3.1.0"
---

## ClickHouse Internal Analytics = Palantir Shard Access

**Core Principle:** Query `internal_analytics` via `internal.query()`. Use `customer.query()` for client data.

**Architecture:**
```mermaid
graph TD
    CH[ClickHouse] --> P[Palantir]
    CH --> M[Montana]

    P --> IA[internal_analytics]
    M --> DTS[DTS clients via MCP]
    M --> RTBM[RTBM-only clients direct]
```

**Routing:**
```mermaid
graph LR
    Q[Query] --> T{Data type?}
    T -->|internal_analytics| I[internal.query]
    T -->|client data| C[customer.query]
    C --> R{Client type?}
    R -->|DTS| MCP[MCP]
    R -->|RTBM-only| Direct[Montana direct]
```

**Primary source:** `data_sources/clickhouse/`
**Session:** 2026-01-01 - v3.1.0 RTBM-only support

### Query Tools

¶1 **CLI:**
```bash
ch internal "SELECT * FROM biz_active_customers LIMIT 5"
ch internal "SELECT name FROM system.tables WHERE database = 'internal_analytics'"
```

¶2 **Python:**
```python
from data_sources.clickhouse import internal

df = internal.query("SELECT * FROM biz_active_customers LIMIT 5")
df = internal.query("SELECT name FROM system.tables WHERE database = 'internal_analytics'")

# Auto-adds internal_analytics. prefix to table names
df = internal.query("SELECT * FROM dim_gong_calls LIMIT 5")
```

### Key Tables

| Table | Purpose | Key Columns |
|-------|---------|-------------|
| `biz_active_customers` | Customers | `dts_agency_id`, `dts_agency_title`, `company_domain_id` |
| `dim_jira_issues` | Jira tickets | `jira_ticket_id`, `jira_domain_id`, `jira_ticket_summary` |
| `dim_gong_calls` | Gong calls | `gong_call_url`, `gong_call_title`, `gong_call_started` |
| `dim_accounts` | Accounts | `account_id`, `account_name`, `mrr` |

### Common Queries

¶1 **Find customer:**
```bash
ch find hp                    # Quick CLI search
```
```python
from data_sources.clickhouse import internal

df = internal.query("""
    SELECT dts_agency_id, dts_agency_title, company_domain_id
    FROM biz_active_customers
    WHERE lower(dts_agency_name) LIKE '%customer%'
""")
```

¶2 **Customer Jira tickets:**
```python
df = internal.query("""
    SELECT jira_ticket_id, jira_ticket_summary, jira_ticket_status
    FROM dim_jira_issues
    WHERE jira_domain_id = 'customer.org'
""")
```

¶3 **Schema discovery:**
```python
# List tables
df = internal.query("SELECT name FROM system.tables WHERE database = 'internal_analytics' AND name LIKE '%jira%'")

# Describe table
df = internal.query("DESCRIBE TABLE internal_analytics.dim_jira_issues")
```

### Ground Truth

- **CLI:** `ch internal "SQL"`
- **Python:** `from data_sources.clickhouse import internal; df = internal.query("SQL")`
- **Database:** `internal_analytics` on Palantir shard

### Customer Data (NOT here)

```python
from data_sources.clickhouse import customer

# DTS client (uses MCP)
df = customer.query("SELECT * FROM facebook", agency="hp.com")

# RTBM-only client (uses Montana direct)
df = customer.query("SELECT * FROM keywords_21_botify", agency="t-mobile.com")

# Find agency info
info = customer.resolve("hp")  # → {'agency_id': 19277, 'is_rtbm_only': False, ...}
```
