---
name: client-intelligence
description: Generate comprehensive project intelligence for Improvado clients. Use when user says "analyze client [name]", "client overview", "project intelligence for [client]", "what's happening with [client]". Automatically finds client folder, queries all context (Gong, Jira, emails), identifies 3-9 projects (MECE), generates detailed reports per project, and creates executive summary.
version: "1.0.0"
---

# Client Intelligence Skill

**Core Purpose:** Generate comprehensive project portfolio overview for any Improvado client using two-phase LLM analysis (identify projects → generate reports → create summary).

## Quick Reference

**Use this skill when:**
- "What's the status with [client]?"
- "Generate project intelligence for [client]"
- "Client overview for [company name]"
- "Analyze all projects for [client]"
- "Create executive summary for [client]"

**Workflow:**
```mermaid
graph LR
    Find[Find Client Folder] --> Load[Load All Context]
    Load --> Phase1[Phase 1: Identify 3-9 Projects]
    Phase1 --> Phase2[Phase 2: Generate Reports]
    Phase2 --> Summary[Create Executive Summary]
    Summary --> Commit[Commit & Share GitHub Links]
```

## Prerequisites

**Required modules (already exist):**
- `client_cases/00_client_context_loader.py` - Loads Gong, Jira, Email, files
- `client_cases/01_project_intelligence_pipeline.py` - Phase 1/2 pipeline
- `client_cases/0_TEMPLATE/00_PROJECT_INTELLIGENCE_TEMPLATE.md` - Report template

**Environment:**
- `GOOGLE_API_KEY` or `GEMINI_API_KEY` in `.env`
- ClickHouse access for internal analytics (Gong, Jira, Email)

## Step-by-Step Execution

### Step 1: Find/Verify Client Folder

**Search for client in ClickHouse:**
```bash
# Using python (ch command may not be in PATH)
claude_venv/bin/python -c "
from data_sources.clickhouse import internal
df = internal.query('''
    SELECT dts_agency_id, dts_agency_title, company_domain_id
    FROM internal_analytics.biz_active_customers
    WHERE lower(dts_agency_title) LIKE '%CLIENT_NAME%'
    LIMIT 5
''')
print(df.to_string())
"
```

**Check existing folder:**
```bash
ls -la client_cases/ | grep -i "client_name"
```

**Folder format:** `im_{agency_id}_{hash}___ClientName`

**If folder doesn't exist:** Create using template from `client_cases/0_TEMPLATE/`

### Step 2: Load All Context

The pipeline automatically loads:
1. **Gong calls** (last 365 days) - from `dim_gong_calls`
2. **Jira tickets** with comments (last 365 days) - from `mrt_jira_tickets`
3. **Email threads** (last 180 days) - from `stg_gmail_cs_messages`
4. **Client files** (Excel, CSV, TXT, SQL) - from client folder

**Manual context check:**
```bash
# Test context loading
claude_venv/bin/python client_cases/00_client_context_loader.py \
  client_cases/im_XXXX_XXX___ClientName/ \
  --domain "clientname" \
  --stats-only
```

### Step 3: Run Phase 1 - Identify Projects

```bash
claude_venv/bin/python client_cases/01_project_intelligence_pipeline.py \
  clientname \
  --phase 1 \
  --docs client_cases/im_XXXX_XXX___ClientName/ \
  --output client_cases/im_XXXX_XXX___ClientName/project_intelligence/
```

**Expected output:** `00_projects_identified.json` with 3-9 projects (MECE)

**Review with user before proceeding:**
```markdown
Found N projects for [Client]:
1. [Project Name] - [Status] - [Key Blocker]
2. ...

Proceed with Phase 2 to generate detailed reports?
```

### Step 4: Run Phase 2 - Generate Reports

```bash
claude_venv/bin/python client_cases/01_project_intelligence_pipeline.py \
  clientname \
  --phase 2 \
  --output client_cases/im_XXXX_XXX___ClientName/project_intelligence/
```

**Expected output:** `NN_project_name_report.md` for each project

### Step 5: Create Executive Summary

After Phase 2, create `00_CLIENT_EXECUTIVE_SUMMARY.md` that combines all projects:

**Template structure:**
```markdown
# [Client]: Executive Project Portfolio Summary

## Thesis
[Client] engagement encompasses [N] projects spanning [domains],
with data flowing through [path], currently facing [M] blockers.

## Portfolio Overview Diagram
[Mermaid diagram showing all projects and data flow]

## Portfolio Health Summary
| Status | Count | Projects |
|--------|-------|----------|
| In Progress | X | ... |
| Waiting | Y | ... |

## Project Portfolio Matrix
[Table with all projects, Jira, status, leads]

## Critical Blockers Across Portfolio
[Top 5 blockers with actions]

## Project Summaries
[Brief summary of each project with next actions]

## Document Links
[GitHub links to all reports]
```

### Step 6: Fix Mermaid Diagrams

**CRITICAL:** GitHub doesn't render emojis in Mermaid diagrams!

**Fix all diagrams:**
- Remove emojis from subgraph labels
- Use underscores in subgraph names (not quotes)
- Simplify edge labels

**Example fix:**
```diff
- subgraph "📋 REQUIREMENTS"
+ subgraph REQUIREMENTS

- B1[🔴 Critical Blocker]
+ B1[Critical Blocker]

- B1 --> |blocks| OUTPUT
+ B1 --> OUTPUT
```

### Step 7: Commit and Share

```bash
cd client_cases/im_XXXX_XXX___ClientName/project_intelligence/
git add .
git commit -m "docs(client): add project intelligence reports for [Client]"
git push
```

**Generate GitHub links:**
```
https://github.com/tekliner/tcs-chrome-extension/blob/main/client_cases/im_XXXX_XXX___ClientName/project_intelligence/00_CLIENT_EXECUTIVE_SUMMARY.md
```

## Key Database Tables

**All on Palantir shard (internal_analytics):**

| Table | Purpose | Key Columns |
|-------|---------|-------------|
| `dim_gong_calls` | Call recordings | `gong_call_url`, `gong_call_title`, `gong_call_content_brief` |
| `mrt_jira_tickets` | Support tickets | `jira_ticket_id`, `jira_ticket_summary`, `jira_comment_body_array` |
| `stg_gmail_cs_messages` | Email threads | `gmail_msg_subject`, `gmail_msg_body`, `gmail_msg_from_email` |
| `biz_active_customers` | Agency lookup | `dts_agency_id`, `dts_agency_title`, `company_domain_id` |

## MECE Project Identification Rules

**Mutually Exclusive:**
- Each project has distinct deliverable
- No overlapping scope
- Clear boundaries

**Collectively Exhaustive:**
- All customer activities covered
- No gaps in coverage
- Include blocked/waiting work

**Project Boundaries (what defines a project):**
- Different Jira epic/ticket series
- Different data sources
- Different stakeholders
- Different timeline/phase

**Target:** 3-9 projects per client (not 1, not 20)

## Report Template Sections

Each project report includes:

| Section | Purpose | Required |
|---------|---------|----------|
| **Thesis** | Single-sentence summary | ✅ |
| **Overview Diagram** | Mermaid data flow + blockers | ✅ |
| **Key Blockers** | Status table + details | ✅ |
| **Quick Reference** | Key facts table | ✅ |
| **§1.0 Requirements** | Source documents | ✅ |
| **§2.0 Specifications** | Metrics, dimensions | If applicable |
| **§3.0 Architecture** | Data flow diagram | If applicable |
| **§4.0 Implementation** | Component status | ✅ |
| **§5.0 Stakeholders** | Teams involved | ✅ |
| **§6.0 Timeline** | Decision history | ✅ |
| **§7.0 Agent Next Steps** | Actions + SQL queries | ✅ |
| **Ground Truth Index** | All citations | ✅ |

## Citation Format

**Always cite sources:**
- `[JIRA:PS-4406]` - Jira ticket
- `[CALL:2025-12-29|Weekly Sync]` - Gong call
- `[EMAIL:2025-12-31|Subject]` - Email thread
- `[EXCEL:filename|sheet]` - Excel file
- `[SQL:model_name.txt]` - SQL model

## Example Execution

```bash
# Full pipeline for Earth Justice
CLIENT="earthjustice"
FOLDER="client_cases/im_XXXX_XXX___ExampleClient"

# Phase 1: Identify projects
claude_venv/bin/python client_cases/01_project_intelligence_pipeline.py \
  $CLIENT --phase 1 --output $FOLDER/project_intelligence/

# Review projects with user...

# Phase 2: Generate reports
claude_venv/bin/python client_cases/01_project_intelligence_pipeline.py \
  $CLIENT --phase 2 --output $FOLDER/project_intelligence/

# Create executive summary manually (or extend pipeline)

# Fix Mermaid, commit, push
```

## Troubleshooting

**Rate limits (429):**
- Reduce `max_tokens` in pipeline (default 200K)
- Wait 60 seconds between phases

**No Gong calls found:**
- Check domain pattern matches `sfdc_company_name_array`
- Try variations: "company", "company.com", "company name"

**JSON parse errors:**
- Pipeline has recovery logic for truncated responses
- Check `/tmp/gemini_response_*.txt` for raw output

**Mermaid not rendering:**
- Remove ALL emojis from diagrams
- Use simple subgraph names without quotes

## Success Criteria

✅ Client folder identified correctly
✅ 3-9 projects identified (MECE)
✅ Each project has detailed report with citations
✅ Executive summary combines all projects
✅ All Mermaid diagrams render on GitHub
✅ GitHub links provided to user

---

**Meta:** This skill reuses existing modules (`00_client_context_loader.py`, `01_project_intelligence_pipeline.py`) following DRY principles. Only the executive summary generation needs to be added inline after Phase 2 completes.
