---
name: deploy-lps-vercel
description: Deploy paid ads landing pages (`paid-ads-lps`) to Vercel via API script without dashboard clicks and without large local uploads. Use when user says "deploy lp", "задеплой лендинг", "deploy paid-ads-lps", "обнови lp.improvado.io", or asks for fast/stable Vercel LP deploy.
version: "1.0.0"
---

# Deploy LPs to Vercel

Fast production deployment for LP project `paid-ads-lps` using API-based flow.

## Scope

- **Project:** `paid-ads-lps`
- **Domains:** `lp.improvado.io`, `improvado-tech.com`
- **Source:** `tekliner/tcs-chrome-extension` (`main`)
- **Primary script:** `algorithms/revenue_div/marketing_dpt/01_projects/claude_code_lps/deploy-lp.sh`

## Why this flow

- `deploy-lp.sh` uses Vercel API with `gitSource` (Vercel pulls from GitHub).
- Avoids `vercel --prod` local upload from monorepo root.
- Typical ready state is ~60-120 seconds.
- Script uses `npx vercel@latest api --scope improvado-marketing` to avoid stale local CLI/token issues.

## Workflow

### Step 1: Ensure code is on `main`
```bash
git add <changed-files>
git commit -m "feat(lps): <change>"
git push origin main
```

### Step 2: Trigger deploy (primary)
```bash
cd algorithms/revenue_div/marketing_dpt/01_projects/claude_code_lps
./deploy-lp.sh
```

### Step 3: Verify
```bash
curl -sI https://lp.improvado.io/lp/main | head -5
curl -sI https://lp.improvado.io/ecom/ | head -5
```

Expected status: `HTTP/2 200`.

## Optional agent-only CI trigger (no UI)

Workflow file: `.github/workflows/deploy-lps-vercel.yml`

```bash
gh workflow run deploy-lps-vercel.yml --ref main
gh run watch
```

Prerequisite: repository secret `VERCEL_TOKEN` with access to `improvado-marketing`.
If Vercel Git auto-deploy is still on, two deploys can run for one push.
Setup once via CLI: `gh secret set VERCEL_TOKEN --repo tekliner/tcs-chrome-extension`.

## Fallback (emergency only)

```bash
# From repo root
npx vercel link --yes --scope improvado-marketing --project paid-ads-lps
npx vercel --prod --yes --archive=tgz
```

Use fallback only when API/script path is unavailable.
