---
name: deploy-miras-vercel
description: Deploy Miras dashboards to Vercel. Use when user says "deploy miras", "vercel deploy", "deploy dashboards", "задеплой miras", "обнови дашборды". Handles production deployment with status reporting.
---

# Deploy Miras to Vercel

Quick deployment of Miras platform dashboards to Vercel production.

## What Gets Deployed

**Target:** `https://verceldeploy-drab.vercel.app`

| Dashboard | Path | Purpose |
|-----------|------|---------|
| HP Investigation | `/index.html` | HP.com data investigation slides |
| ClickHouse Test | `/clickhouse_test.html` | Palantir connection test |
| Client Communication | `/client_communication.html` | Key clients last Gong call |

## Quick Usage

When user says any of:
- "deploy miras"
- "deploy to vercel"
- "обнови дашборды"
- "задеплой"

Execute this deployment workflow.

## Deployment Workflow

### Step 1: Navigate to deploy directory
```bash
cd $PROJECT_ROOT/data_sources/motia/investigate/hp_investigation/vercel_deploy
```

### Step 2: Deploy to production
```bash
vercel --prod
```

### Step 3: Report success
After deployment completes, report:
- Deployment URL: https://verceldeploy-drab.vercel.app
- Available dashboards (list above)
- Deployment time

## Environment Variables (Already Configured)

| Variable | Value |
|----------|-------|
| CLICKHOUSE_HOST | db-access.palantir.tools.improvado.io |
| CLICKHOUSE_PORT | 443 |
| CLICKHOUSE_USER | internal_analytics_daniel_k |
| CLICKHOUSE_PASSWORD | (configured) |
| NOTION_TOKEN | (configured) |

## Authentication

- **Google OAuth Client ID:** `479107778836-4m1caroh98ao07uo405mo7e0u2qujq81.apps.googleusercontent.com`
- **Authorized users:** All `@improvado.io` emails
- **Documented in:** [[miras authentication]] (Logseq)

## Adding New Dashboards

1. Create `new_dashboard.html` in `vercel_deploy/`
2. If needs API endpoint, create `api/endpoint_name.py`
3. Update `vercel.json` routes if needed
4. Run `vercel --prod`

## Adding New Environment Variables

```bash
cd $PROJECT_ROOT/data_sources/motia/investigate/hp_investigation/vercel_deploy
printf '%s' 'value_without_newline' | vercel env add VAR_NAME production
vercel --prod  # Redeploy to apply
```

## Troubleshooting

### OAuth Error "invalid_client"
- Check OAuth Client ID matches `479107778836-...`
- Verify authorized origin includes `verceldeploy-drab.vercel.app`
- See [[miras authentication]] in Logseq

### API Returns 500
- Check env vars are set: `vercel env ls`
- Check ClickHouse credentials are valid
- View logs: `vercel logs`

## Documentation

- **Logseq:** [[publish investigation results to vercel]]
- **Logseq:** [[miras authentication]]
- **Local:** `vercel_deploy/deploy.sh`

---
Created: 2026-01-06
Purpose: Quick Miras dashboard deployment to Vercel
