# Download Session from Drive - Quick Reference

**Purpose:** Download Claude Code sessions from Google Drive and install to current project for immediate resume.

## ⚠️ Prerequisites

**REQUIRED:** `data_sources/google_drive/credentials/credentials.json` with Google Drive API access.

See [data_sources/google_drive/00_README.md](../../../data_sources/google_drive/00_README.md) for setup instructions.

## Quick Start

```bash
# Navigate to target project
cd ~/your-project

# Option 1: Interactive mode (prompts for selection)
python3 .claude/skills/download-session-from-drive/download_session.py

# Option 2: Auto-select by number
python3 .claude/skills/download-session-from-drive/download_session.py --select 1

# Option 3: Download by session ID
python3 .claude/skills/download-session-from-drive/download_session.py --session-id f7a79beb

# Option 4: With force flag (skip overwrite confirmation)
python3 .claude/skills/download-session-from-drive/download_session.py --select 1 --force
```

## Command Line Flags

| Flag | Short | Description |
|------|-------|-------------|
| `--select N` | `-s N` | Auto-select session by number (1-N) without prompting |
| `--session-id ID` | `-i ID` | Download specific session by ID (full or partial) |
| `--force` | `-f` | Skip overwrite confirmation (auto-overwrite) |
| `--help` | `-h` | Show help message with examples |

## Workflow

```
1. Authenticate → 2. List sessions → 3. Select → 4. Download → 5. Install → 6. Resume
```

## Key Features

- 📋 **Browse before download** - See metadata (CWD, branch, date) for each session
- ⭐ **Smart highlighting** - Sessions from current project marked with ⭐
- 🔄 **CWD flexible** - Sessions work regardless of original directory
- ⚠️ **Overwrite protection** - Prompts before replacing existing sessions
- 🔐 **Auto-auth** - First time opens browser, then uses cached token

## Installation Location

Sessions install to: `~/.claude/projects/{current-dir-encoded}/{session-id}.jsonl`

Example:
- Current dir: `$PROJECT_ROOT`
- Encoded: `-Users-as-Desktop-Impro-tcs-chrome-extension`
- Installed: `~/.claude/projects/-Users-as-Desktop-Impro-tcs-chrome-extension/f7a79beb...jsonl`

## Resume After Download

```bash
# Full ID
claude --resume f7a79beb-138f-4858-8edc-f18ffa076bf0

# Short ID
claude --resume f7a79beb

# Universal resume (if configured)
rc f7a79beb
```

## Common Scenarios

### Download to current project
```bash
cd ~/project
User: "Download session from Drive"
# Select session → Installed to current project
```

### Download session from different machine
```bash
# Machine A: Upload session
User: "Upload this session to Drive"

# Machine B: Download session
cd ~/project
User: "Download session from Drive"
# Works! CWD difference is OK
```

### Import session to multiple projects
```bash
# Project 1
cd ~/project-1
User: "Download session X from Drive"

# Project 2
cd ~/project-2
User: "Download same session X from Drive"
# Both work! Session available in both projects
```

## Troubleshooting

| Problem | Solution |
|---------|----------|
| No sessions found | Upload a session first: "Upload this session to Drive" |
| Authentication failed | Check credentials in `data_sources/google_drive/credentials/` |
| Session already exists | Choose 'y' to overwrite or 'n' to cancel |
| Can't resume after install | Make sure you're in the same directory where you installed |

## Files Created

- Downloaded to: `/tmp/claude-sessions/{session-id}.jsonl` (temporary)
- Installed to: `~/.claude/projects/{encoded-path}/{session-id}.jsonl` (permanent)
- Temp file auto-deleted after installation

## Security Notes

⚠️ **Sessions contain full conversation history:**
- All messages and responses
- Tool usage and results
- File contents read during session
- Only download sessions from trusted sources

## Related

- **Upload:** `upload-session-to-drive` skill
- **Search:** `claude-code-sessions` skill
- **Docs:** [SKILL.md](./SKILL.md) for detailed documentation
- **Client:** [GoogleDriveClient](../../../data_sources/google_drive/drive_client.py)

## Implementation

**Script:** [download_session.py](./download_session.py)

**Dependencies:**
- GoogleDriveClient (existing)
- OAuth2 credentials configured
- Google Drive API access

---

**Tip:** Look for ⭐ marker to quickly find sessions from current project!
