---
name: dts-postgres
description: Query DTS PostgreSQL via Redash API for marketing data warehouse. Use when user says "DTS Postgres", "Redash query", "marketing warehouse", "funnel analysis".
version: "2.0.0"
---

## 📋 DTS Postgres = Marketing Data Warehouse via Redash

**Core Principle:** Query DTS PostgreSQL through Redash API for marketing attribution and schema discovery.

**Access Architecture (Continuant - TD):**
```mermaid
graph TD
    Skill[DTS Skill] --> Client[DTSPostgresClient]
    Client --> Redash[Redash API]
    Redash --> DTS[(DTS PostgreSQL)]

    DTS --> Public[public schema]
    DTS --> Marketing[marketing schema]
```

**Query Execution (Occurrent - LR):**
```mermaid
graph LR
    Q[Query] --> C[Client] --> R[Redash API]
    R --> J[Job Created]
    J --> P[Poll Status]
    P --> D[Return Data]
```

**Ontological Rule:** TD for access layers, LR for query execution flow

**Primary source:** `data_sources/dts_postgres/dts_postgres_redash_client.py`
**Session:** 2025-12-03 by Claude Code - v2.0.0 KF migration

### 🎯 CLI Commands

¶1 **Core operations:**
```bash
python -m data_sources.dts_postgres.dts_postgres_redash_client test
python -m data_sources.dts_postgres.dts_postgres_redash_client query "SELECT * FROM public.companies LIMIT 10"
python -m data_sources.dts_postgres.dts_postgres_redash_client tables --schema public
python -m data_sources.dts_postgres.dts_postgres_redash_client describe companies --schema public
python -m data_sources.dts_postgres.dts_postgres_redash_client search "marketing"
```

### 📐 Python Integration

```python
from data_sources.dts_postgres.dts_postgres_redash_client import DTSPostgresClient

client = DTSPostgresClient()
result = client.execute_query("SELECT * FROM public.companies LIMIT 10")
tables = client.get_tables(schema='public')
matches = client.search_tables('marketing')
```

### 📊 Schema Discovery

¶1 **Workflow:**
```bash
# 1. List schemas
python -m data_sources.dts_postgres.dts_postgres_redash_client schema
# 2. List tables
python -m data_sources.dts_postgres.dts_postgres_redash_client tables --schema marketing
# 3. Describe table
python -m data_sources.dts_postgres.dts_postgres_redash_client describe attribution --schema marketing
```

¶2 **Key tables:** `public.companies`, `public.campaigns`, `marketing.attribution`, `marketing.funnel_stages`

### 🔧 Environment

```bash
REDASH_API_URL=https://redash.improvado.io
REDASH_API_TOKEN=your_token
DTS_POSTGRES_DATA_SOURCE_ID=your_id
```

### Ground Truth

- **Client:** `data_sources/dts_postgres/dts_postgres_redash_client.py`
- **API:** Redash at `https://redash.improvado.io`
- **NOT for:** ClickHouse data (use `clickhouse-internal-analytics` or `improvado-mcp`)
