# Fireflies Calls Skill

Search and analyze call recordings from Fireflies.ai with AI-generated summaries and full transcripts.

## Quick Start

Ask Claude:
```
Find calls about ECM from last week
```

```
What did we discuss in the bio.xyz call?
```

```
Show me action items from call ID 01K8RH3QTPMF92ZR63K0TK516D
```

## What This Skill Does

- 🔍 **Search calls** by keyword, title, participant, or date
- 📝 **Get summaries** with overview, keywords, and outline
- ✅ **Extract action items** automatically
- 💬 **Read transcripts** with speaker attribution
- 📊 **Analyze conversations** from meetings

## Example Output

```
📅 ECM launching on bio.xyz discussion
ID: 01K8RH3QTPMF92ZR63K0TK516D
Date: Tuesday, November 04, 2025 at 07:30
Duration: 0.6 minutes

👥 Participants (3):
   - daniel@improvado.io
   - contact@example.com
   - rakhan@example.com

📝 SUMMARY:
- ECM Aging Database creation for hypothesis generation
- $100,000 funding for CRO studies
- Two token launches: AI agent + IP token
- Bio takes 6.9% fee, founders keep control

✅ ACTION ITEMS:
- Submit two applications to Bio's launchpad
- Review tokenomics documentation
- Discuss next steps with collaborator

💬 TRANSCRIPT (331 sentences):
James Sinka: Bunch of these interviews back to back.
Rakhan: That's okay. Yeah...
```

## Search Examples

### By Keyword
```python
client.search_meetings(keyword="token launch", limit=20)
```

### By Participant
```python
client.search_meetings(participant_email="contact@example.com")
```

### By Date Range
```python
client.search_meetings(
    date_from="2025-11-01",
    date_to="2025-11-04"
)
```

### Combined
```python
client.search_meetings(
    keyword="ECM",
    participant_email="rakhan@example.com",
    date_from="2025-11-01"
)
```

## API Key

Automatically loaded from `.env`:
```
FIREFLIES_API_KEY="<see .env file>"
```

## Files

- **SKILL.md** - Complete skill documentation
- **Client:** `data_sources/fireflies/fireflies_client.py`

## Version

v1.0 (2025-01-15)
