---
name: folder-finder
description: Use when user asks "where should I put this?" or wants to add new content. Automatically analyzes content type and recommends appropriate folder in chrome-extension-tcs (algorithms/client_cases/data_sources). Ensures proper organization by division and purpose.
---

# Folder Finder Skill

Find the right home for new content in the chrome-extension-tcs repository by analyzing content type and repository structure.

## When to Use This Skill

Use this skill when:
- User wants to add external article/research to repository
- User needs to create new documentation
- Creating new analysis, guide, or reference material
- Unclear which folder fits the content purpose

## Quick Start Checklist

When user wants to organize content:

```markdown
[ ] 1. Identify content type: article, code, analysis, or documentation
[ ] 2. Determine audience: internal team, specific customer, or integration
[ ] 3. Classify category: algorithms vs client_cases vs data_sources
[ ] 4. Find appropriate subdivision (e.g., product_div, A8_G&A_div)
[ ] 5. Check existing files, determine next number prefix (NN_)
[ ] 6. Propose location with reasoning
[ ] 7. Confirm with user before creating
```

**5-Second Decision Tree:**
- Customer-specific content? → client_cases/
- Integration/API code? → data_sources/
- Internal operations/analysis? → algorithms/ (then determine division)

## Practical Workflow

**BEFORE creating any new file:**

1. **Analyze content** (What? Who? Why?)
   - What: AI agents, market research, customer data?
   - Who: Product team, Daniel personal, specific customer?
   - Why: Reference, implementation, documentation?
2. **Map to category** (algorithms/client_cases/data_sources)
3. **Choose subdivision** (product_div/Ai Agent vs market_research)
4. **Check last file** (determine next NN_ prefix)
5. **Propose to user** with reasoning and alternatives
6. **Confirm** before writing file

**Example rapid application:**
```
User: "Save this Anthropic article about AI agent security"

Agent thinks:
- Type: External article (research)
- Topic: AI agent security patterns
- Audience: AI Agent team (internal)
- Category: algorithms/product_div/Ai Agent/
- Check last file: 01_xxx.md
- Propose: 02_anthropic_security_pattern.md
```

## Repository Structure Overview

The chrome-extension-tcs repository has THREE main categories:

### 1. **algorithms/** - Internal Improvado Operations
Organized by business divisions (product, sales, marketing, G&A, revenue, RevOps, CS)

**Subdirectories:**
- `product_div/` - Product division work
  - `00_Architecture/` - Architecture docs and patterns
  - `Multi_agent_framework/` - Multi-agent systems
  - `Ai Agent/` - AI Agent development
  - `Ai Agent as Improvado product/` - AI Agent as product
  - `market_research/` - Market analysis
  - `client_quotes_analysis/` - Client feedback analysis
  - `MMM/` - Marketing Mix Modeling
  - `LES/` - Lead Engagement Score

- `Sales/` - Sales division operations
- `Marketing/` - Marketing analytics
- `revenue_div/` - Revenue operations
- `A8_G&A_div/` - G&A (General & Administrative)
  - `Daniel Personal/` - Daniel's personal work

- `03 CS/` - Customer Success
- `RevOps/` - Revenue Operations
- `competitive_intelligence/` - Competitive analysis

### 2. **client_cases/** - Customer Projects
Individual customer folders with format: `im_{agency_id}_{hash}___ClientName`

**Structure:** Customer data, dashboards, analyses, communication history

**When to use:** ONLY for client-specific deliverables and data

### 3. **data_sources/** - External System Integrations
Connectors and utilities for external systems

**Examples:** `gong/`, `notion/`, `jira/`, `gmail/`, `clickhouse/`, `supabase/`, `fireflies/`

**When to use:** Integration code, API clients, data extraction utilities

## Decision Framework

### Step 1: Identify Content Type

**Ask yourself:**
1. **Is this customer-specific?** → `client_cases/`
2. **Is this integration/connector code?** → `data_sources/`
3. **Is this internal Improvado work?** → `algorithms/`

### Step 2: For Internal Work (algorithms/)

**Content Type Mapping:**

**Architecture & Design Patterns:**
- Security patterns, system design, architectural decisions
- **→** `algorithms/product_div/00_Architecture/`

**AI Agent Development:**
- Agent capabilities, behaviors, security, tools
- **→** `algorithms/product_div/Ai Agent/`

**AI Agent as Product:**
- Product strategy, go-to-market, positioning
- **→** `algorithms/product_div/Ai Agent as Improvado product/`

**Multi-Agent Systems:**
- Agent orchestration, parallel execution, frameworks
- **→** `algorithms/product_div/Multi_agent_framework/`

**Market Research:**
- Competitive analysis, market trends, industry insights
- **→** `algorithms/product_div/market_research/`

**Customer Analysis:**
- Customer feedback, quotes, sentiment analysis
- **→** `algorithms/product_div/client_quotes_analysis/`

**Analytics Models:**
- MMM, LES, attribution models
- **→** Respective folders (`MMM/`, `LES/`, etc.)

**Personal Work:**
- Daniel's explorations, experiments, personal notes
- **→** `algorithms/A8_G&A_div/Daniel Personal/`

**Division-Specific Work:**
- Sales analysis → `algorithms/Sales/`
- Marketing metrics → `algorithms/Marketing/`
- CS operations → `algorithms/03 CS/`
- Revenue ops → `algorithms/RevOps/`

## Usage Pattern

When user provides content to organize:

### 1. Analyze Content
```
- What is the content about? (AI agents, architecture, customer data, etc.)
- Who is the audience? (internal team, specific customer, specific division)
- What is the purpose? (reference, implementation, analysis, documentation)
```

### 2. Propose Location
```
Based on analysis:
- **Recommended folder:** `path/to/folder/`
- **Reasoning:** [Explain why this location fits]
- **Alternative options:** [If applicable]
```

### 3. Confirm with User
```
Does this location make sense? Or would you prefer:
- Option A: [alternative path]
- Option B: [another alternative]
```

### 4. Suggest Filename
```
Following numbering convention: `NN_descriptive_name.md`
Examples:
- `01_dual_llm_security_pattern.md`
- `02_agent_tool_permissions.md`
- `03_prompt_injection_prevention.md`
```

## Examples

### Example 1: External Article about AI Security
```
Content: Archestra blog post about Dual LLM pattern for AI agent security

Analysis:
- Topic: AI agent security architecture
- Audience: Internal (AI Agent team)
- Purpose: Reference for security implementation

Recommendation: `algorithms/product_div/Ai Agent/`
Reasoning:
- Security pattern for AI agents (not general architecture)
- Directly applicable to AI Agent development
- Team-specific knowledge

Filename: `01_dual_llm_security_pattern.md`
```

### Example 2: Market Research Report
```
Content: Gartner report on AI Agent market trends

Analysis:
- Topic: Market analysis, competitive landscape
- Audience: Product division, leadership
- Purpose: Strategic planning reference

Recommendation: `algorithms/product_div/market_research/`
Reasoning:
- External market intelligence
- Informs product strategy
- Not specific to AI Agent implementation

Filename: `03_gartner_ai_agent_market_2025.md`
```

### Example 3: Customer Dashboard Analysis
```
Content: Analysis of ExampleClient's marketing performance

Analysis:
- Topic: Customer-specific data analysis
- Audience: ExampleClient account team
- Purpose: Client deliverable

Recommendation: `client_cases/im_XXXX_XXX___MB2_Dental/analyses/`
Reasoning:
- Customer-specific content
- Uses customer data
- Part of client engagement

Filename: `02_marketing_performance_q4_2025.md`
```

### Example 4: Notion API Client
```
Content: Python module for Notion API operations

Analysis:
- Topic: External system integration
- Audience: All teams using Notion
- Purpose: Reusable utility

Recommendation: `data_sources/notion/`
Reasoning:
- Integration code for external system
- Reusable across projects
- Not division-specific

Filename: `notion_client.py` (already exists - would extend)
```

## File Naming Convention

**MANDATORY:** ALL files must have numeric prefix

**Pattern:** `NN_descriptive_name.extension`

**Examples:**
- `00_README_folder_name.md` - Folder overview (always 00)
- `01_main_topic.md` - Primary content
- `02_secondary_topic.md` - Additional content
- `03_analysis_name.md` - Analysis documents

**Artifacts:** Match parent file prefix
- `06_capture_dashboard.py` creates `06_screenshots/`
- `12_analysis_script.py` creates `12_results/`

## Quality Checks

Before recommending folder:

- [ ] **Verified category:** algorithms vs client_cases vs data_sources
- [ ] **Checked division:** Product, Sales, Marketing, CS, RevOps, etc.
- [ ] **Considered alternatives:** Evaluated 2-3 possible locations
- [ ] **Explained reasoning:** Clear logic for recommendation
- [ ] **Suggested filename:** With proper numeric prefix
- [ ] **Confirmed with user:** Asked for approval before creating

## Anti-Patterns

❌ **Putting everything in root:** No files directly in repo root
❌ **Skipping numeric prefix:** All files need NN_ prefix
❌ **Wrong category:** Client data in algorithms/, internal work in client_cases/
❌ **Generic folders:** Creating "misc/", "temp/", "other/" folders
❌ **No confirmation:** Creating files without user approval
❌ **Vague reasoning:** Not explaining WHY this folder fits

## Success Criteria

✅ User understands WHY the folder was recommended
✅ Location aligns with repository organization
✅ Filename follows numbering convention
✅ Content will be discoverable by relevant teams
✅ Future similar content has clear precedent

---

**Meta Note:** This skill helps maintain repository organization by ensuring new content lands in the right place based on purpose, audience, and type.
