# Notion Configuration

Reference for Notion block formats, database properties, and page structure.

## Events Database

- **Database ID:** `fe49ffa8-3d47-4d7b-a06c-f9fd9ac04a7b`
- **Properties:** Name, Recording URL, Meeting date, Attendees, Organizer, Done?

---

## Page Content Structure (CRITICAL!)

The Meeting Notes page MUST follow this structure:

```
┌─────────────────────────────────────────────────────────────┐
│ 🎯 CALLOUT (blue_background)                                │
│   📞 Call Recording: [Gong Link](url)                       │
│   📅 Date: December 3, 2025                                 │
│   ⏱️ Duration: ~10 minutes                                  │
└─────────────────────────────────────────────────────────────┘

## Participants
**Client Name:** Person 1, Person 2
**Improvado:** Person 1 (PM), Person 2 (Tech Lead)

---

## Call Summary
{3 paragraphs covering: main blockers, key decisions, outcomes}

---

## Jira Tickets Discussed

▶ 🔴 PS-3768 - Dashboard Feedback (BLOCKER) | @Ilia Kolesnikov
  │ 📍 Timestamp: [00:17](gong_url&t=17)
  │ > "Quote from call..." — Speaker
  │ Problem: {description}
  │ ☐ Action item 1
  │ ☐ Action item 2
  │ ⏰ Deadline: Dec 3 (TODAY)

▶ 🟡 PS-3779 - KP Taxonomy (Epic) | @Ilia Kolesnikov
  │ 📍 Timestamp: [01:37-08:31](gong_url&t=97)
  │ > "Quote..." — Speaker
  │ Progress: ✓ Done items / ⏳ Pending items
  │ ☐ Action item 1
  │ ☐ Action item 2

---

## Next Steps
┌─────────┬──────────────────────────────────┬──────────────┐
│ Owner   │ Task                             │ Deadline     │
├─────────┼──────────────────────────────────┼──────────────┤
│ Ilia    │ Grant Power BI permission        │ Dec 3 (TODAY)│
│ Elyse   │ Provide timeline to Chad         │ Dec 10-11    │
└─────────┴──────────────────────────────────┴──────────────┘

---
📝 Generated by Claude Code | Two-agent verification
🔗 Session: {session_id}
```

---

## Block Types Used

| Block Type | Purpose | Usage |
|------------|---------|-------|
| **Callout** | Header (FIRST!) | Blue background + 💡 icon with Gong link, date, duration |
| **Heading 2** | Section headers | Participants, Summary, Tickets, Next Steps |
| **Paragraph** | Participants | Bold labels + attendee names |
| **Toggle** | Each ticket | **COLLAPSIBLE** with details inside (children) |
| **Paragraph** | Content | Timestamps `[00:17]` → `gong_url&t=17` |
| **Quote** | Transcript quotes | With speaker attribution |
| **To-do** | Action items | Checkboxes inside toggles |
| **Table** | Next Steps | Owner/Task/Deadline columns |

**⚠️ IMPORTANT:** Toggle blocks with children ARE supported by Notion API!

---

## Toggle Block (Collapsible Ticket)

```python
{
    "type": "toggle",
    "toggle": {
        "rich_text": [
            {"type": "text", "text": {"content": "🟢 "}},
            {"type": "text", "text": {"content": "PS-4522", "link": {"url": jira_url}}, "annotations": {"bold": True}},
            {"type": "text", "text": {"content": " — Ticket Title"}},
            {"type": "text", "text": {"content": " | @Assignee"}, "annotations": {"color": "gray"}}
        ],
        "children": [
            # All details go inside children array
            {"type": "paragraph", "paragraph": {"rich_text": [{"type": "text", "text": {"content": "📍 Timestamp: [MM:SS]"}}]}},
            {"type": "quote", "quote": {"rich_text": [{"type": "text", "text": {"content": "Quote..."}}]}},
            {"type": "paragraph", "paragraph": {"rich_text": [{"type": "text", "text": {"content": "📝 Description"}}]}}
        ]
    }
}
```

---

## Status Emoji Convention

| Emoji | Status | Meaning |
|-------|--------|---------|
| 🔴 | BLOCKER | Blocking other work |
| 🟡 | IN PROGRESS | Active work |
| 🟢 | DONE/LOW | Completed or low priority |

---

## Annotations (CRITICAL!)

The `annotations` object MUST be at same level as `text`, NOT inside it:

**✅ CORRECT:**
```json
{
    "type": "text",
    "text": {"content": "Bold text"},
    "annotations": {"bold": true}
}
```

**❌ WRONG:**
```json
{
    "type": "text",
    "text": {"content": "Bold text", "annotations": {"bold": true}}
}
```

---

## Callout Block (Header) - MANDATORY FIRST BLOCK

Every Meeting Notes page MUST start with this header callout:

```python
{
    "type": "callout",
    "callout": {
        "rich_text": [
            {"type": "text", "text": {"content": "📞 Call Recording: "}},
            {
                "type": "text",
                "text": {"content": "Gong Link", "link": {"url": gong_url}},
                "annotations": {"bold": True, "underline": True}
            },
            {"type": "text", "text": {"content": f"\n📅 Date: {date_str}"}},
            {"type": "text", "text": {"content": f"\n⏱️ Duration: ~{duration_minutes} minutes"}}
        ],
        "icon": {"emoji": "💡"},
        "color": "blue_background"
    }
}
```

**Required fields:**
- `gong_url` - Full Gong recording URL
- `date_str` - Formatted date like "December 3, 2025"
- `duration_minutes` - Call duration from Gong metadata

---

## Participants Section - MANDATORY AFTER HEADER

Immediately after the header callout, add Participants section:

```python
# Heading
{
    "type": "heading_2",
    "heading_2": {
        "rich_text": [{"type": "text", "text": {"content": "Participants"}}]
    }
}

# Participants paragraph (parsed from doc.participants list)
# Format: ["Client: Person1, Person2", "Improvado: Person1 (CSM), Person2"]
{
    "type": "paragraph",
    "paragraph": {
        "rich_text": [
            {"type": "text", "text": {"content": "Simantel:"}, "annotations": {"bold": True}},
            {"type": "text", "text": {"content": " Person1, Person2\n"}},
            {"type": "text", "text": {"content": "Improvado:"}, "annotations": {"bold": True}},
            {"type": "text", "text": {"content": " Person1 (CSM), Person2 (Tech Lead)"}}
        ]
    }
}
```

---

## Heading 2 Block

```python
{
    "type": "heading_2",
    "heading_2": {
        "rich_text": [{"type": "text", "text": {"content": "Call Summary"}}]
    }
}
```

---

## Quote Block

```python
{
    "type": "quote",
    "quote": {
        "rich_text": [
            {"type": "text", "text": {"content": "Quote text here..."}},
            {"type": "text", "text": {"content": " — Speaker"}, "annotations": {"italic": True}}
        ]
    }
}
```

---

## Clickable Timestamp Link

Format: `[MM:SS]` linking to `gong_url&t=SECONDS`

```python
{
    "type": "text",
    "text": {
        "content": "[02:33]",
        "link": {"url": f"{gong_url}&t=153"}
    }
}
```

---

## Bullet List Block

```python
{
    "type": "bulleted_list_item",
    "bulleted_list_item": {
        "rich_text": [{"type": "text", "text": {"content": "Item text"}}]
    }
}
```

---

## To-Do Block (Action Items)

```python
{
    "type": "to_do",
    "to_do": {
        "rich_text": [{"type": "text", "text": {"content": "Action item"}}],
        "checked": False
    }
}
```

---

## Table Block (Next Steps)

```python
{
    "type": "table",
    "table": {
        "table_width": 3,
        "has_column_header": True,
        "has_row_header": False,
        "children": [
            {
                "type": "table_row",
                "table_row": {
                    "cells": [
                        [{"type": "text", "text": {"content": "Owner"}, "annotations": {"bold": True}}],
                        [{"type": "text", "text": {"content": "Task"}, "annotations": {"bold": True}}],
                        [{"type": "text", "text": {"content": "Deadline"}, "annotations": {"bold": True}}]
                    ]
                }
            },
            {
                "type": "table_row",
                "table_row": {
                    "cells": [
                        [{"type": "text", "text": {"content": "Ilia"}}],
                        [{"type": "text", "text": {"content": "Grant Power BI permission"}}],
                        [{"type": "text", "text": {"content": "Dec 3 (TODAY)"}}]
                    ]
                }
            }
        ]
    }
}
```

---

## Footer with Session ID (MANDATORY!)

Every page MUST include session ID for traceability:

```python
{
    "type": "paragraph",
    "paragraph": {
        "rich_text": [
            {"type": "text", "text": {"content": "📝 Generated by Claude Code | "}, "annotations": {"italic": True, "color": "gray"}},
            {"type": "text", "text": {"content": "Two-agent verification"}, "annotations": {"italic": True, "color": "gray"}},
            {"type": "text", "text": {"content": "\n🔗 Session: "}, "annotations": {"italic": True, "color": "gray"}},
            {"type": "text", "text": {"content": session_id}, "annotations": {"code": True}}
        ]
    }
}
```

**How to get Session ID:**
```bash
python data_sources/claude_code/get_session_id.py --quiet
# Returns: e1561bfc-70d4-471b-8395-6af18acaf97e
```

---

## Create Page with Properties

```python
import requests

payload = {
    "parent": {"database_id": "fe49ffa8-3d47-4d7b-a06c-f9fd9ac04a7b"},
    "properties": {
        "Name": {
            "title": [{"text": {"content": "Client | Improvado - Working Session (Dec 3, 2025)"}}]
        },
        "Meeting date": {
            "date": {"start": "2025-12-03"}
        },
        "Recording URL": {
            "url": gong_url
        },
        "Meeting type": {
            "multi_select": [{"name": "Customer call"}]
        },
        "Done?": {
            "checkbox": True
        }
    }
}

response = requests.post(
    "https://api.notion.com/v1/pages",
    headers=headers,
    json=payload
)
page_id = response.json()["id"]
```

---

## Append Blocks to Page

```python
blocks = [
    # ... list of blocks
]

# Notion limit: 100 blocks per request
for i in range(0, len(blocks), 100):
    batch = blocks[i:i+100]
    response = requests.patch(
        f"https://api.notion.com/v1/blocks/{page_id}/children",
        headers=headers,
        json={"children": batch}
    )
```
