---
name: gong-to-jira-notion
description: Run Gong to Jira/Notion pipeline to extract call insights and action items. Use when user says "process Gong call", "gong pipeline", "gong to jira", "запусти пайплайн", or provides a Gong call URL for processing.
---

# Gong Pipeline

> **Full Documentation:** [Obsidian: Gong - Notion - Jira Pipeline](obsidian://open?vault=vault&file=Miras%20Knowledge%20Platform%2FMiras%20Intelligence%2FBusiness%20Workflow%20Miras%2FGong_-_Notion_-_Jira)
>
> **Troubleshooting:** [Obsidian: Gong Pipeline Troubleshooting](obsidian://open?vault=vault&file=Miras%20Knowledge%20Platform%2FMiras%20Intelligence%2FBusiness%20Workflow%20Miras%2FGong_Pipeline_Troubleshooting)

## Trigger Words

- "process Gong call", "analyze call", "gong to jira"
- "run pipeline", "gong pipeline", "запусти пайплайн"
- "test pipeline for [client]", "debug pipeline"
- Gong URL asking to extract action items

## Quick Start

```bash
# 1. Check if Motia running
lsof -i :3000

# 2. Start if needed
cd $PROJECT_ROOT/data_sources/motia
npx motia dev

# 3. Trigger (auto-finds latest call!)
curl -s -X POST http://localhost:3000/gong/trigger \
  -H "Content-Type: application/json" \
  -d '{"dim_domain_id": "hp.com"}' | jq .
```

## What It Does

```
Gong Call → Claude + Gemini → Opus Arbiter → Notion + Jira
```

1. Fetch transcript from ClickHouse
2. Discover client (agency, Epic)
3. Parallel analysis (Claude + Gemini)
4. Opus Arbiter merge (Rule 8 anti-hallucination)
5. Create Notion page
6. Add Jira comments (with Notion link)
7. Create new Jira tickets

## Monitor

```bash
# Quick status
redis-cli GET "motia:state:pipelines:p-ID" | python3 -m json.tool

# Or open Workbench
open http://localhost:3000
```

## Test Clients

```bash
curl -s POST :3000/gong/trigger -d '{"dim_domain_id":"hp.com"}'
curl -s POST :3000/gong/trigger -d '{"dim_domain_id":"earthjustice.org"}'
curl -s POST :3000/gong/trigger -d '{"dim_domain_id":"kaiserpermanente.org"}'
```

## Key Files

| File | Purpose |
|------|---------|
| `data_sources/motia/src/gong/trigger-pipeline.step.ts` | API |
| `data_sources/motia/src/analysis/synthesize_step.py` | Opus Arbiter |
| `data_sources/motia/src/jira/jira_executor.py` | Jira API |

---

**Version:** 2026-01-24 — Consolidated from gong-to-jira-notion + motia-gong-pipeline
