# Gong-to-Jira-Notion Skill Release Log

## v2.8.1 (2025-12-04)

### Fixed (CRITICAL BUG)

- **Jira Tickets Created Unassigned** — Execute phase wasn't assigning tickets!
  - **Problem**: `execute_synthesis.py` created JiraExecutor WITHOUT `default_assignee_id`
  - **Root cause**: `context.json` didn't include `default_assignee_id` and `reporter_id`
  - **Solution**:
    1. `main.py` now saves `default_assignee_id` and `reporter_id` to context.json
    2. `execute_synthesis.py` reads them and passes to JiraExecutor
  - **Result**: Tickets now correctly assigned to first Improvado call participant

### Files Modified

- `main.py` — `prepare_analysis_context()` now includes `default_assignee_id`, `reporter_id`, and top-level `epic_key`
- `execute_synthesis.py` — `TaskExecutor.__init__()` reads assignee/reporter from context; `jira_executor` property passes them to JiraExecutor

### Technical Details

**Before (broken):**
```python
# execute_synthesis.py line 118
self._jira_executor = JiraExecutor(epic_key=self.epic_key)
# Missing: default_assignee_id, reporter_id → tickets created UNASSIGNED
```

**After (fixed):**
```python
# context.json now includes:
{
  "default_assignee_id": "5e123...",  # First Improvado participant
  "reporter_id": "5f456...",          # Epic reporter
  ...
}

# execute_synthesis.py now uses them:
self._jira_executor = JiraExecutor(
    epic_key=self.epic_key,
    default_assignee_id=self.default_assignee_id,
    reporter_id=self.reporter_id
)
```

---

## v2.8.0 (2025-12-04)

### Added (MAJOR FEATURE)

- **Parallel Two-Agent Analysis** — Gemini + Claude run IN PARALLEL!
  - **Problem**: Sequential analysis was slow, and Claude wasn't doing independent analysis
  - **Solution**: ThreadPoolExecutor runs both agents simultaneously
  - **Key insight**: Both agents must analyze INDEPENDENTLY before synthesis (no bias)

### New Files

- **`lib/claude_analyzer.py`** (~230 lines) — Claude Sonnet 4 based analyzer:
  - Same structure as gemini_analyzer.py for consistency
  - Uses `anthropic` Python SDK
  - Outputs `03_claude_analysis.json`

- **`lib/parallel_analyzer.py`** (~240 lines) — Parallel orchestrator:
  - `run_gemini_analysis()` and `run_claude_analysis()` via ThreadPoolExecutor
  - Both run simultaneously, results collected as they complete
  - Auto-runs synthesis after both succeed
  - Outputs: `03_gemini_analysis.json`, `03_claude_analysis.json`, `04_SYNTHESIS.json`

### New CLI Flag

```bash
# Run parallel Two-Agent analysis
python main.py --analyze <call_id>
```

**Workflow now:**
```
1. python main.py <gong_url>           # Ingest
2. python main.py --analyze <call_id>  # Parallel Gemini + Claude + Synthesis
3. python main.py --execute <call_id>  # Create tickets + Notion
```

### Performance

- **Sequential (old)**: Gemini ~15s + Claude ~15s = 30s total
- **Parallel (new)**: max(Gemini, Claude) ≈ 15s total
- **~2x faster** analysis phase!

### Files Modified

- `main.py` — Added `--analyze` flag and parallel analysis handler
- Ingest output now shows recommended `--analyze` command

---

## v2.7.0 (2025-12-04)

### Added (MAJOR FEATURE)

- **Task List Contract Pattern** — Explicit task tracking for guaranteed completion!
  - **Problem**: Agent could stop mid-execution, skip tasks, or forget steps
  - **Solution**: Generate explicit task list BEFORE execution with dependencies
  - **Key insight**: Agent cannot "forget" tasks when they are explicitly listed and validated

### New Files

- **`lib/task_list.py`** (~450 lines) — Core Task List Contract module:
  - `Task` dataclass with id, type, status, dependencies, output, validation
  - `TaskList` container with dependency tracking and `is_complete()` check
  - `TaskListGenerator.from_synthesis()` — creates tasks from 04_SYNTHESIS.json
  - `TaskListRenderer.render()` — console output with step grouping
  - `ValidationGate.validate()` — type-specific output validation
  - `TaskListPersistence` — save/load for resume capability

- **`execute_synthesis.py`** (rewritten ~500 lines) — Execute phase with TaskExecutor:
  - `TaskExecutor` class that processes tasks in dependency order
  - `_execute_task()` runs task and validates output
  - `_run_task()` dispatches to correct handler by TaskType
  - Saves progress to `06_TASK_LIST.json` after each task

### Task Types and Dependencies

```
Task 1: CREATE_NOTION_PAGE     ← No dependencies
Task 2: CREATE_JIRA_TICKET     ← Depends on Task 1 (needs notion_url)
Task 3: CREATE_JIRA_TICKET     ← Depends on Task 1
...
Task N: ADD_JIRA_COMMENT       ← Depends on Task 1
Task N+1: COMPLETE_NOTION_PAGE ← Depends on Tasks 1..N (needs all ticket_keys)
```

### Validation Gates

| Task Type | Validation |
|-----------|------------|
| `CREATE_NOTION_PAGE` | `notion_url` exists, starts with `https://` |
| `CREATE_JIRA_TICKET` | `ticket_key` exists, starts with `PS-` |
| `ADD_JIRA_COMMENT` | `success == True` |
| `COMPLETE_NOTION_PAGE` | `blocks_added >= 5` |

### Output Files

- `06_TASK_LIST.json` — Task list state (saved after each task)

### Architecture Document Updated

- Added Section 4.1 "Task List Contract (v2.7.0)"
- Updated file structure to include new modules
- Added console output example

---

## v2.6.1 (2025-12-04)

### Added

- **Execution Modes** — Two modes for different use cases:
  - `--mode auto` (default): Runs all steps to completion without stopping
  - `--mode approve`: Shows what Gemini/Claude found, waits for user confirmation

- **Approve Mode Details:**
  - Shows Gemini findings (ticket count, first 5 titles)
  - Shows Claude findings (ticket count, first 5 titles)
  - Shows Synthesis result with confidence levels (🟢 HIGH, 🟡 MEDIUM)
  - Displays action summary (create X tickets, update Y, create Notion page)
  - Prompts `Proceed? [y/N]` — only continues on explicit yes

- **Reinforced Completion** — `auto` mode ensures agent runs to completion:
  - No pause points in the workflow
  - Agent cannot stop mid-execution
  - All 3 steps (Notion→Jira→Notion) always complete

### Files Modified

- `main.py` — Added `--mode` argument, approve mode logic (lines 768-852)
- `SKILL.md` — Documented modes in Phase 3 section

---

## v2.6.0 (2025-12-04)

### Added (MAJOR FEATURE)

- **Bidirectional Notion ↔ Jira Linking** — Agent can no longer mess up execution order!
  - **Problem**: Agent could create Jira tickets without Notion link, or create Notion without ticket links
  - **Solution**: New 3-step enforced execution flow:
    1. **Step 1**: Create EMPTY Notion page first → get `notion_url`
    2. **Step 2**: Create Jira tickets WITH `notion_url` in each description
    3. **Step 3**: Complete Notion page WITH Jira ticket links
  - **Key insight**: Code structure ENFORCES correct order (not just instructions)
    - Step 2 NEEDS `notion_url` from Step 1
    - Step 3 NEEDS `ticket_key` from Step 2
    - Agent physically cannot skip steps

### Technical Details

- `execute_synthesis.py` restructured into 3 explicit steps
- `_get_session_id()` helper added for portable session detection
- `create_ticket()` now receives `notion_url` parameter
- `add_content_blocks()` called AFTER tickets created with mappings
- Each Jira ticket description includes: "Notion Action Items" link

### Files Modified

- `execute_synthesis.py` — complete rewrite of execution flow (lines 82-340)

---

## v2.5.4 (2025-12-04)

### Fixed

- **Meeting type now "Customer call"** (was "Occasional meeting")
  - Notion Events database property
  - Updated: `lib/notion_publisher.py`, `CONFIG_NOTION.md`

---

## v2.5.3 (2025-12-04)

### Changed (CRITICAL)

- **Now creates ALL tickets, not just HIGH confidence**
  - **Problem**: Was filtering to only HIGH confidence tickets (2 of 11)
  - **User feedback**: "Создай все тикеты" — all valid tickets should be created
  - **Solution**: Removed `if conf_level != 'HIGH': continue` filter
  - Deduplication by title still works (no duplicates)
  - Output now shows: "Creating 11 unique tickets (2 HIGH, 9 MEDIUM)"

### Files Modified

- `execute_synthesis.py` — lines 96-117 (removed HIGH-only filter)

---

## v2.5.2 (2025-12-04)

### Added

- **`--execute` flag now works!** — Was a stub printing "Not yet implemented"
  - Auto-discovers `gong_processing/{call_id}` folder across all client_cases
  - Loads `context.json` and `04_SYNTHESIS.json` automatically
  - Runs full execute phase: Jira tickets + Notion page
  - Saves results to `05_EXECUTION_RESULTS.json`

### Usage

```bash
# After running Two-Agent Analysis (Gemini + Claude → Synthesis):
python main.py --execute 7832716595142003667
```

### Files Modified

- `main.py` — lines 718-785 (replaced stub with full implementation)

---

## v2.5.1 (2025-12-04)

### Changed (Portability)

- **Removed all hardcoded paths** — Skill now portable to any machine
  - `main.py`: Replaced `$PROJECT_ROOT` with `PROJECT_ROOT` from `lib/base.py`
  - `execute_synthesis.py`: Same fix
  - `_get_session_id()`: Session path now derived from `PROJECT_ROOT` dynamically

### Technical Details

- All Python files now use `lib/base.py` for path resolution
- Pattern: `Path(__file__).parent` → `lib/base.PROJECT_ROOT`
- Session folder derived as: `~/.claude/projects/{PROJECT_ROOT.replace('/', '-')}/*.jsonl`

### Files Modified

- `main.py` — lines 22-29, 102-108
- `execute_synthesis.py` — lines 17-24

---

## v2.5.0 (2025-12-03)

### Fixed (CRITICAL)

- **Smart Assignee from call participants**: Tickets now auto-assigned to first Improvado participant
  - **Problem**: All tickets created with "Unassigned" — nobody owned the work
  - **Solution**: New `_get_smart_assignee_id()` method in `main.py`
    - Priority 1: First Improvado email from `gong_call_improvado_emails_array` → Jira lookup
    - Priority 2: Epic's default assignee
    - Priority 3: None (fallback)
  - **Result**: Tickets assigned to actual call participant (e.g., Shanti Oppenheimer)

- **Priority mapping (High → Critical)**: PS project doesn't have "High" priority
  - **Problem**: Jira API rejected tickets with `priority: "High"`
  - **Solution**: Added `PRIORITY_MAP` and `_normalize_priority()` in `jira_executor.py`
    - `high` → `Critical`
    - `blocker` → `Critical`
    - `medium` → `Medium`
    - `low` → `Low`
  - **Result**: All priority values normalized before API call

- **Notion table None values**: 400 error when `deadline` was None
  - **Problem**: `step.get('deadline', '')` returns None if key exists with None value
  - **Solution**: Use `step.get('deadline') or ''` pattern in `_build_next_steps_blocks()`
  - **Result**: Table renders without API errors

### Changed

- **JiraExecutor init order**: Moved AFTER `run_ingest_phase()` in `main.py`
  - Reason: Smart assignee needs `actual_improvado_team` populated from Gong fetch
  - Before: JiraExecutor created before transcript parsed → no participant data
  - After: JiraExecutor created after ingest → has participant emails

### Files Modified

- `main.py` — `_get_smart_assignee_id()`, reordered JiraExecutor init
- `lib/jira_executor.py` — `PRIORITY_MAP`, `_normalize_priority()`
- `lib/notion_publisher.py` — fixed None handling in next_steps table

---

## v2.4.1 (2025-12-04)

### Fixed (CRITICAL)
- **Session ID footer now ALWAYS appears** — was missing due to duplicate content logic
  - Root cause: `create_event_page()` added content blocks AND `publish()` called `add_content_blocks()` → duplication
  - Footer in `create_event_page()` was conditional on `session_id` existing
  - Solution: Removed content block addition from `create_event_page()` (now only creates page properties)
  - All content including footer now added ONLY by `add_content_blocks()` which ALWAYS adds footer

### Changed
- **`create_event_page()`**: Now only creates page with properties, no content blocks
- **Single source of content**: All blocks added by `add_content_blocks()` (DRY principle)

### Files Modified
- `lib/notion_publisher.py` — removed duplicate content block logic from `create_event_page()`

---

## v2.4.0 (2025-12-04)

### Fixed (CRITICAL)
- **Two-Agent Verification now MANDATORY** — Agent was skipping Claude analysis
  - Root cause: SKILL.md said "Recommended" → interpreted as optional
  - Session `2683124a-846a-4a2a-b85f-80c9608e0bc0` showed agent running only Gemini

### Changed
- **Workflow diagram**: Now shows full 7-step flow with parallel Gemini + Claude → Synthesis
- **Phase 2 renamed**: "ANALYZE (Agent)" → "TWO-AGENT ANALYSIS (⚠️ MANDATORY)"
- **Critical Rules**: Added rule #1: "⚠️ TWO-AGENT VERIFICATION IS MANDATORY"
- **main.py output**: Now prints explicit 4-step TWO-AGENT workflow with commands

### Files Modified
- `SKILL.md` — Mermaid diagram, Phase 2, Critical Rules
- `main.py` — Output message now shows all 4 steps explicitly

---

## v2.3.0 (2025-12-04)

### Added
- **Billable by default**: Engagement Type changed from `10877` (Non-billable) to `10876` (Billable)
  - Per Ilia Kolesnikov's request
  - Affects: `lib/jira_executor.py`, `lib/agency_discovery.py`

- **Agency Name field (customfield_10290)**: Auto-populated from SFDC data
  - Source: `company_domain_id` from `biz_active_customers` table
  - Format: domain (e.g., "earthjustice.org", "ruderfinn.com")
  - `ClientContext.domain_id` — new field

- **Smart Reporter detection**: Cascading fallback logic
  - Priority 1: Epic's reporter (from `defaults['reporter_id']`)
  - Priority 2: SFDC Primary CSM (`sfdc_primary_csm_emails` → Jira lookup)
  - Priority 3: Default to Ilia Kolesnikov (`6165c9bcd9bb5e0069b8b212`)
  - New method: `main.py._get_smart_reporter_id()`

- **SFDC data integration**: New method `AgencyDiscovery.get_sfdc_data()`
  - Queries `internal_analytics.biz_active_customers`
  - Returns: `company_domain_id`, `sfdc_primary_csm_name`, `sfdc_primary_csm_emails`
  - `ClientContext.primary_csm_email` — new field

### Changed
- `JiraExecutor.__init__()` — new params: `agency_domain_id`, `reporter_id`
- `get_defaults_from_epic()` — now also fetches Epic's reporter

### Files Modified
- `lib/jira_executor.py` — Billable default, Agency Name, Reporter fields
- `lib/agency_discovery.py` — SFDC data, ClientContext fields, Epic reporter
- `main.py` — `_get_smart_reporter_id()`, updated JiraExecutor init
- `CONFIG_JIRA.md` — updated default engagement type

---

## v2.2.2 (2025-12-04)

### Fixed
- **Filter attendees by ACTUAL speakers** (CRITICAL): ClickHouse stores INVITED participants, not actual attendees
  - **Problem**: Nermin was in calendar invite but didn't speak → appeared in Notion attendees incorrectly
  - **Solution**: Cross-reference `gong_call_improvado_emails_array` with `transcript.speakers`
    - Extract name from email: `user@improvado.io` → `ilia kolesnikov`
    - Match against actual speaker names (case-insensitive)
    - Only include those who actually spoke in the call
  - **Result**: Notion attendees now reflect WHO SPOKE, not who was invited

### Files Modified
- `main.py` — added speaker filtering logic in `run_ingest_phase()` (lines 192-233)

---

## v2.2.1 (2025-12-04)

### Fixed
- **Attendees matching by EMAIL** (CRITICAL): Исправлен алгоритм `_find_notion_users()`
  - **Проблема**: "Ilya" матчился на "Ilya Telegin" вместо "Ilia Kolesnikov"
  - **Решение**: Приоритет matching:
    1. Exact email match (самый надёжный)
    2. Full name match
    3. First+Last name parts from email
  - Email'ы берутся из ClickHouse `gong_call_improvado_emails_array`
  - Внешние участники (не @improvado.io) автоматически пропускаются

- **Content blocks**: Исправлено добавление контента на Notion страницу
  - `create_event_page()` теперь вызывает все `_build_*_blocks()` методы
  - Добавлен PATCH запрос для append блоков
  - Chunking по 100 блоков (Notion API limit)

- **Transcript metadata passthrough**: `main.py` теперь сохраняет `self.transcript_metadata`
  - `participants` передаётся в `ActionItemsDoc` из ClickHouse данных
  - `call_date` берётся из реальной даты звонка

### Files Modified
- `lib/notion_publisher.py` — `_find_notion_users()` rewritten for email priority, `create_event_page()` now appends blocks
- `main.py` — stores `transcript_metadata`, passes emails to ActionItemsDoc

---

## v2.2.0 (2025-12-04)

### Added
- **Session ID in Notion footer**: Для traceability — Claude Code session ID добавляется в footer каждой страницы
  - `ActionItemsDoc.session_id: Optional[str]` — новое поле
  - `_get_session_id()` в main.py — автоопределение из env или файлов сессий
  - Footer формат: `📄 Document prepared: 2025-12-04 | 🔗 Session: uuid-here`

- **`--agency-id` CLI параметр**: Для случаев когда имя клиента не в Gong title
  - `python main.py "gong_url" --agency-id 18377`
  - Bypasses auto-discovery, использует `discover_from_agency_id()`

- **`lib/synthesis.py`**: Two-agent merge module с confidence scoring
  - HIGH (0.95): оба агента согласны
  - MEDIUM (0.60-0.70): один агент или partial agreement
  - LOW (0.40): конфликт — нужен manual review

### Fixed
- **Gemini model**: Зафиксирован `gemini-3-pro-preview` с комментарием "DON'T CHANGE"
- **Customer page relation**: Notion страницы теперь линкуются к customer в Customers database

### Files Modified
- `lib/notion_publisher.py` — session_id в footer, `_find_customer_page_id()`
- `lib/synthesis.py` — NEW: two-agent merge
- `lib/gemini_analyzer.py` — model lock + JSON ticket support
- `main.py` — `--agency-id` param, `_get_session_id()`
- `SKILL.md` — release log notice top/bottom

---

## v2.1.1 (2025-12-03)

### Added
- **Header callout block**: Blue callout at top of page with:
  - 📞 Call Recording: clickable Gong link (bold + underline)
  - 📅 Date: formatted date (e.g., "December 3, 2025")
  - ⏱️ Duration: call duration from metadata (e.g., "~18 minutes")
  - 💡 icon emoji

- **Participants section**: Added after header callout
  - Format: `**Client Name:** Person1, Person2`
  - Format: `**Improvado:** Person1 (CSM), Person2 (Tech Lead)`

- **New ActionItemsDoc fields**:
  - `duration_minutes: Optional[int]` - call duration for header
  - `client_name: Optional[str]` - client name for participants

### Files Modified
- `lib/notion_publisher.py` - added `_build_header_callout()`, `_build_participants_block()`, updated `add_content_blocks()` order
- `CONFIG_NOTION.md` - documented header callout with icon

---

## v2.1.0 (2025-12-03)

### Fixed
- **Notion toggle blocks**: Changed from `callout` to `toggle` blocks for collapsible tickets
  - New tickets now collapsible with ▶ toggle
  - Updates to existing tickets also collapsible
  - Removed wrong comment "API doesn't support toggle with children"

- **Priority values in LLM prompt**: Added exact Jira priority names to Gemini prompt
  - `Blocker`, `Critical`, `Medium`, `Low` (not "High")
  - Removed unnecessary `_map_priority()` function from jira_executor.py

- **JSON ticket support**: `gemini_analyzer.py` now reads both `.md` and `.json` ticket files

### Changed
- Section headers:
  - "Jira Tickets Discussed" → "✅ New Tickets Created"
  - "Ticket Updates" → "🔄 Updates to Existing Tickets"

### Files Modified
- `lib/notion_publisher.py` - toggle blocks implementation
- `lib/gemini_analyzer.py` - priority values + JSON support
- `lib/jira_executor.py` - removed unused mapping
- `CONFIG_NOTION.md` - added toggle block example

---

## v2.0.0 (2025-12-03)

### Added
- Initial refactored version with DRY architecture
- Modular lib/ structure
- Two-agent verification (Gemini + Claude)
- Progress tracking and resume capability

### Files
- `main.py` - orchestrator
- `lib/base.py` - centralized clients
- `lib/gong_fetcher.py` - transcript fetch
- `lib/agency_discovery.py` - client lookup
- `lib/jira_sync.py` - incremental sync
- `lib/jira_executor.py` - ticket creation
- `lib/notion_publisher.py` - page publishing
- `lib/gemini_analyzer.py` - LLM analysis
- `lib/synthesis.py` - two-agent merge
