---
name: graph-add
description: "Smart content addition to Obsidian vault via 2-pass Gemini. Phase 1: navigate vault tree, Phase 2: expand + decide + write content. Claude reviews and executes. Use when user says: 'add to vault', 'save this to obsidian', 'добавь в обсидиан', 'create vault page', 'graph add', 'запиши в vault'."
version: "3.0.0"
---

# /graph_add — Smart Content Addition to Obsidian Vault (v3)

**Thesis:** 2-pass Gemini pipeline — Gemini navigates vault tree, reads candidate files, decides UPDATE/CREATE/REFACTOR, and writes the actual content. Claude reviews the plan and executes it.

## Execution Protocol

### Step 1: Prepare Session Summary

Claude (the agent) writes a concise session summary covering:
- All topics/tasks worked on
- Key entities (customers, tools, people, technologies)
- Artifacts created or modified (files, skills, configs)
- Patterns, decisions, gotchas discovered

Keep it 3-8 sentences. This is the input for Gemini.

### Step 2: Run graph_add() Python Function

```bash
claude_venv/bin/python -c "
import sys, json
sys.path.insert(0, '.')
from data_sources.obsidian.ops import graph_add

plan = graph_add('''SESSION_SUMMARY_HERE''')

print(json.dumps({
    'action': plan.action,
    'filepath': plan.filepath,
    'section': plan.section,
    'content': plan.content,
    'remove_lines': plan.remove_lines,
    'reasoning': plan.reasoning,
    'secondary_updates': plan.secondary_updates,
}, ensure_ascii=False, indent=2))
"
```

This runs the full pipeline:
1. **Gemini #1 (Flash):** Navigates compact vault tree → finds 3-5 candidate files/folders
2. **Python:** Expands top-3 candidates (reads file content, up to 100 lines each)
3. **Gemini #2 (Pro):** Receives session summary + expanded content → returns ActionPlan

### Step 3: Review Gemini's Plan

Claude MUST review before executing:
- Is the target file correct?
- Is the section appropriate?
- Does the content make sense?
- Are remove_lines actually contradictory?
- Do secondary_updates look reasonable?

If anything seems wrong — adjust or ask user.

### Step 4: Execute

Based on `action` field:

#### UPDATE
```
mcp__obsidian__patch_vault_file(
    filename="filepath from plan",
    target="section from plan",
    targetType="heading",
    operation="append",
    content="content from plan"
)
```
If `remove_lines` is not null — Read file, Edit to remove those lines first, then append.

#### CREATE
```
mcp__obsidian__create_vault_file(
    filename="filepath from plan",
    content="content from plan"
)
```

#### REFACTOR
Follow Gemini's plan: create consolidated file, patch old files with `> [!info] Consolidated into [[New File]]`.

For `secondary_updates` — apply each one the same way.

## Architecture

```
Claude (session summary)
    → Python: graph_add(summary)
        → Gemini Flash: suggest_placement → candidates
        → Python: expand_nodes → file contents
        → Gemini Pro: decide_action → ActionPlan
    ← ActionPlan {action, filepath, section, content}
Claude reviews → executes via MCP/Edit
```

**Gemini = author** (navigates, decides, writes content)
**Claude = reviewer + executor** (validates, uses tools)

## Content Rules

- **Wikilinks:** `[[File Name]]` (name only, no paths)
- **Tags:** in frontmatter `tags:` array
- **Dates:** ISO `YYYY-MM-DD`
- **No secrets:** per CLAUDE.md §2.1 ¶4
- **Session tracking:** add `session_id:` to frontmatter per §2.3

## Related Skills

| Skill | Relationship |
|-------|-------------|
| `/graph_find` | Independent — graph_add has its own search via suggest_placement |
| `/obsidian` | MCP tools for execution (create, patch, show) |
| `/knowledge-framework` | Apply MECE structure for docs >50 lines |

---
Created: 2026-02-05 | Version: 3.0.0
Changes: v3 — 2-pass Gemini pipeline replacing graph_find dependency. Gemini writes content, Claude reviews+executes.
