# Skill Release Log

## [2.3.0] - 2025-11-26
**Session ID:** Current session by Daniel Kravtsov
**Type:** Merge release - Combined v2.0.4 + v2.2.0
**Changes:**
- ✅ **Merged v2.0.4 (CLI improvements)** with **v2.2.0 (Browser automation)**
- ✅ **Combined global .env loading** - Works from any directory
- ✅ **All CLI features preserved** - 5-min cache TTL, tool help, cache invalidation
- ✅ **Browser automation preserved** - Playwright auto-open with DTS cookie
- ✅ **Documentation unified** - Single coherent SKILL.md with all features
**Technical Details:**
- Resolved git merge conflicts in 3 files
- Preserved hardcoded global .env path for skill portability
- Merged validation results from both branches
**Issue:** Parallel development branches needed reconciliation

## [2.2.0] - 2025-11-21
**Session ID:** Current session by Daniel Kravtsov
**Type:** Feature Enhancement - Browser Automation
**Changes:**
- ✅ **Browser automation with Playwright** - Auto-open incognito browser with DTS cookie
- ✅ **Created `/algorithms/product_div/00_set_dts_cookie_browser.py`** - One-line command to launch authenticated browser
- ✅ **Documented impersonate user** - Explained `impersonate-user-{workspace_id}@external.improvado.io` virtual users
- 📝 **Added "🌐 Browser Automation with DTS Cookie" section** to SKILL.md
- 🔧 **Manual fallback** - Documented legacy browser console method
**Technical Details:**
- Playwright creates isolated browser context (like incognito)
- Cookie set BEFORE page load → no redirect to /login
- Script auto-detects workspace_id from agency_id via ClickHouse
- Virtual impersonate user has Chief-level permissions
**Testing:**
- ✅ Tested on ExampleClient (agency_id=XXXX, workspace_id=YYYY)
- ✅ Tested on Improvado Marketing (agency_id=XXXX, workspace_id=YYYY)
- ✅ Both browsers opened with pre-authenticated sessions
**Use Case:** Quick workspace testing, manual QA, debugging customer issues
**Self-Healing:** Replaced unreliable AppleScript with robust Playwright automation

## [2.1.0] - 2025-11-19
**Session ID:** Current session
**Type:** Infrastructure Enhancement - Global Skill Support
**Changes:**
- ✅ **Global skill support** - Added symlink in `~/.claude/skills/improvado-mcp`
- ✅ **Robust .env loading** - Hardcoded path to `chrome-extension-tcs/.env` (follows `supabase-agent` pattern)
- ✅ **Works from any location** - Tested from `/tmp`, `~`, other projects
- ✅ **Priority-based loading** - Global .env → Relative .env → .env.local
- 📝 **Documentation** - Added "🌍 Global Usage" section to SKILL.md
- 🔧 **Improved mcp_client.py** - Uses `Path.resolve()` to avoid duplicate loading
**Technical Details:**
- `mcp_client.py` now loads `.env` from `$PROJECT_ROOT/.env` first
- Symlink: `~/.claude/skills/improvado-mcp` → `chrome-extension-tcs/.claude/skills/improvado-mcp`
- Backward compatible with relative paths
**Testing:**
- ✅ Credentials loaded from `/tmp` directory
- ✅ Full client creation from home directory
- ✅ Environment variables accessible globally
**Issue:** Making improvado-mcp skill available globally like other skills (knowledge-framework, multi-agent-orchestrator, notion-tasks-operations)
**Self-Healing:** Applied proven pattern from supabase-agent for global .env loading

## [2.0.4] - 2025-11-25
**Session ID:** TBD by Daniel Kravtsov
**Type:** Performance improvement
**Changes:**
- Reduced tools cache TTL from 24 hours to 5 minutes
- Changed `CACHE_TTL_HOURS = 24` to `CACHE_TTL_MINUTES = 5` in session.py
- Updated cache expiration logic: `hours_since_cache` → `minutes_since_cache`
- New tools on server now discovered within 5 minutes instead of 24 hours
**Issue:** 24-hour cache was too long - new tools on server took a day to appear in CLI

## [2.0.3] - 2025-11-25
**Session ID:** TBD by Daniel Kravtsov
**Type:** Documentation fix
**Changes:**
- Fixed all command examples to use `python3 mcp_client.py` instead of `python` or `improvado-mcp`
- Updated argparse epilog with correct command syntax
- Updated all error messages with proper command references (5 locations)
- Documentation consistency across SKILL.md and mcp_client.py
**Issue:** Inconsistent command examples caused user confusion - showed wrong `improvado-mcp` alias

## [2.0.2] - 2025-11-25
**Session ID:** TBD by Daniel Kravtsov
**Type:** Bug fix
**Changes:**
- Fixed tools cache invalidation on workspace switch
- Added `self.clear_tools_cache()` to `set_workspace_context()` in session.py
- Tools list now refreshes automatically after switching agencies
- Solves issue where `list-tools` showed 21 base tools after switching to agency with 46 tools
**Issue:** Tools cache was not cleared when switching workspace context, causing stale tool list display

## [2.0.1] - 2025-11-25
**Session ID:** TBD by Daniel Kravtsov
**Type:** Feature enhancement
**Changes:**
- Added comprehensive tool help system: `python mcp_client.py call <tool_name> --help`
- Enhanced `generate_help()` in ToolRegistry to display:
  - Enum values (e.g., `<enum[line, bar, area, pie, scatter, table]>`)
  - Nested object properties with indentation
  - Array item schemas with required field markers
- Modified `call_parser` to disable auto-help and handle `--help` manually
- Added `show_tool_help()` function for tool-specific help display
- Graceful error handling for non-existent tools
**Issue:** Users couldn't discover tool argument schemas without reading MCP server docs

## [2.0.0] - 2025-11-24
**Session ID:** TBD by Daniel Kravtsov
**Type:** Major architecture change
**Changes:**
- Transformed from Python-only library to full-featured CLI tool
- Added argparse-based command interface (init, session, switch, list-tools, call, query)
- Implemented session management with `~/.improvado_mcp_session`
- Created ToolRegistry for dynamic tool discovery and caching (24h TTL)
- Added multiple output formats (table, json, csv) for query results
- Persistent workspace context across commands
- Tool categorization and search functionality
- No more need to write Python scripts for every query
**Issue:** Python library required writing scripts for every operation, poor UX

## [2.0.0-legacy] - 2025-11-19
**Session ID:** `92a507f4-1d1b-4b1a-a508-6377dc0953e0` by Daniel Kravtsov
**Type:** Major update - Self-healing after runtime error
**Changes:**
- **Added dual-endpoint architecture** (public session-based + internal Basic Auth)
- **Documented session-based authentication** via `impersonate_agency(workspace_id)`
- **Added complete connector discovery workflow** with `getConnectionsTool`
- **Explained security model** - why credentials not returned via API (defense-in-depth)
- **Updated Mermaid diagrams** - TD for dual-endpoint architecture, LR for session workflow
- **Added troubleshooting section** - common connector discovery issues and solutions
- **Updated tool lists** - 41 public tools vs 79 internal tools
**Issue:** Runtime error when trying to find connectors for Marketing Agency - 3059
**Root Cause:** Original skill only documented `-internal` endpoint with Basic Auth, which returned `403 Forbidden`. Public endpoint `/mcp/v1/invoke/` with session-based auth works correctly for connector operations.
**Self-Healing:** Automatically updated skill after discovering correct endpoint and auth method during connector search session.

## [1.0.1] - 2025-11-17
**Session ID:** `a50b4ae4-aa21-4762-a121-22243286f07f` by Daniel Kravtsov
**Type:** Testing and documentation update
**Changes:**
- Updated tool count: 79 tools available (was documented as 32)
- Added comprehensive testing section with validation results
- Tested workspace switching (ExampleClient, Improvado Marketing) ✅
- Tested ClickHouse queries with client data ✅
- Tested Discovery API (Facebook, Google Ads connectors) ✅
- Tested workspace tools (tables, extracts) ✅
- Tested integration tools (Notion, Jira, Knowledge Base) ✅
- Added ClickHouse access limitation warning (no `internal_analytics` access)
- 14/15 core tests passed (93% success rate)
**Issue:** Tool count correction and comprehensive validation

## [1.0.0] - 2025-11-17
**Session ID:** `a50b4ae4-aa21-4762-a121-22243286f07f` by Daniel Kravtsov
**Type:** Initial release
**Changes:**
- Created improvado-mcp skill with Knowledge Framework structure
- Added ImprovadoMCPClient with auto .env loading
- 79 MCP tools available (ClickHouse, Discovery API, workspace switching, Notion, Jira, Reports, etc.)
- Mermaid TD/LR diagrams for architecture and workflow
- MECE sections with ¶-numbering
- Tools reference documentation
- Bilingual triggers (English + Russian)
**Issue:** Consolidated implementation from `data_sources/improvado_mcp/` into Claude Code skill
