# Improvado MCP Tools Reference

This document lists all 32 available MCP tools with their descriptions.

## Base Tools (Always Available)

### clickhouseTool
Execute SQL queries against ClickHouse database to retrieve data from `internal_analytics.*` tables.

### webSearchTool
Search the web for current information using Tavily Search API.

### visualizationTool
Generates chart visualizations from data. Supports line, bar, pie charts.

### heatmapVisualizationTool
Creates a heatmap visualization from data matrix.

### semrushDomainRanksTool
Gets traffic and keyword data for a domain from SEMrush.

### semrushDomainOrganicTool
Gets keyword information for a list of competing domains from SEMrush.

### semrushCompareDomainsRanksTool
Compares traffic and keywords for multiple competing domains.

### semrushDomainAdwordsTool
Gets paid keyword (Adwords) information for a domain from SEMrush.

### imageAnalyzerTool
Analyzes images from provided URLs.

### documentationTool
Execute OpenAI Assistant API calls to interact with a specific assistant.

### sendEmailTool
Send emails with markdown content converted to HTML. Supports attachments.

### pythonTool
Python execution (currently disabled - E2B sandbox dependency).

## Discovery Tools

### discoveryRequestTool
Call the discovery API for a given datasource and connector.

### discoveryListConnectorsTool
List all connectors for a given datasource.

### discoveryGetApiVersionsTool
Get all API versions for a specific data source.

### discoveryQueryApiDocumentationTool
Query specific data source and API version documentation.

### discoveryListAccountsTool
List all accounts with optional filtering and pagination.

### discoveryWebSearchTool
Search the web for current information using Tavily Search API (discovery-specific).

### retrieveDocumentationTool
Retrieve documentation for a given url.

## Workspace-Specific Tools (Require Context)

### listDataTablesTool
List data tables for current workspace.

### getConnectionsTool
Get connections for current workspace.

### createExtractTool
Create a new extract in workspace.

### updateExtractTool
Update an existing extract.

### pauseExtractTool
Pause an extract.

### unpauseExtractTool
Unpause an extract.

### listAllExtractsTool
List all extracts in workspace.

### createLoadTool
Create a new load.

### updateLoadTool
Update an existing load.

### pauseLoadTool
Pause a load.

### unpauseLoadTool
Unpause a load.

### runLoadTool
Run a load.

### deleteLoadTool
Delete a load.

### listDestinationsTool
List destinations in workspace.

### getDestinationConnectionTool
Get destination connection details.

### updateDestinationConnectionTool
Update destination connection.

## Impersonation Tools

### getCurrentWorkspaceContextTool
Get the currently active workspace impersonation context. Returns null if not set.

### switchWorkspaceContextTool
Switch context to a specific agency workspace for impersonation. Parameters:
- `rtbm_agency_id` (required) - Agency ID
- `workspace_id` (optional) - Specific workspace, defaults to agency's default workspace

## Cerebro Tools

### createCerebroRuleTool
Create a new Cerebro rule in a notebook.

### updateCerebroRuleTool
Update an existing Cerebro rule in a notebook.

### getCerebroRuleRunsTool
Get the run history for a Cerebro rule notebook.

## MDG Tools

### createMdgViewTool
Create or replace MDG view in agency schema.

### getMdgRulesTool
Get Marketing Data Governance prompt instructions.

### getMdgRuleLibraryExampleTool
Fetch a specific MDG rule example from the library by rule name.

### testMdgNotificationTool
Test an MDG rule by executing it and sending the results via email.

## Knowledge Base Tools

### getKnowledgeBaseFiles
Get the content of a specific markdown or HTML file from the knowledge base.

### getKnowledgeBaseStructure
Get the complete structure of the user's knowledge base, including folders and files.

## Chat Tools

### findChat
Search for chats across the agency. Returns a list of matching chats.

### getChat
Get a chat by ID. Retrieves the full information of a specific chat conversation.
