"""
Created by: Claude Code
Session ID: TBD
Date: 2025-11-24
Purpose: Configuration constants for Improvado MCP Client
"""

import os
from pathlib import Path

# Auto-load .env files if python-dotenv is available
try:
    from dotenv import load_dotenv
    # Try to find .env file in project root
    env_path = Path(__file__).parent.parent.parent.parent / '.env'
    if env_path.exists():
        load_dotenv(env_path)
    # Also try .env.local
    env_local = Path(__file__).parent.parent.parent.parent / '.env.local'
    if env_local.exists():
        load_dotenv(env_local)
except ImportError:
    # python-dotenv not installed, will use existing env vars
    pass

# Default MCP Server URL
# Can be overridden via IMPROVADO_MCP_SERVER_URL environment variable
# Examples:
#   - Local: http://localhost:3000/experimental/agent/api/mcp-internal/v1/invoke/
#   - Production: https://report.improvado.io/experimental/agent/api/mcp-internal/v1/invoke/
DEFAULT_MCP_SERVER_URL = os.environ.get(
    "IMPROVADO_MCP_SERVER_URL",
    "https://report.improvado.io/experimental/agent/api/mcp-internal/v1/invoke/"
)
