#!/usr/bin/env python3
"""
Get DTS session ID for Improvado workspace
Usage: python3 get_dts_session.py --workspace 121 --agency 3756
"""

import sys
import argparse
from pathlib import Path

# Load environment variables
try:
    from dotenv import load_dotenv
    env_path = Path('$PROJECT_ROOT/.env')
    if env_path.exists():
        load_dotenv(env_path)
except ImportError:
    pass

# Add chrome-extension-tcs to path
chrome_extension_path = Path('$PROJECT_ROOT')
sys.path.insert(0, str(chrome_extension_path))

from client_cases.sql_server import impersonate_agency

def main():
    parser = argparse.ArgumentParser(description='Get DTS session ID for workspace')
    parser.add_argument('--workspace', type=str, required=True, help='Workspace ID')
    parser.add_argument('--agency', type=str, help='Agency ID (optional)')

    args = parser.parse_args()

    try:
        session_id = impersonate_agency(
            workspace_id=args.workspace,
            rtbm_agency_id=args.agency if args.agency else None
        )
        print(session_id)
        return 0
    except Exception as e:
        print(f"Error: {e}", file=sys.stderr)
        return 1

if __name__ == "__main__":
    sys.exit(main())
