# Limitless Conversations - Quick Reference

## 🚀 Quick Commands

```bash
# Fetch today's conversations
python3 algorithms/A8_G\&A_div/Daniel\ Personal/Daniel_communications/code/02_fetch_limitless_wrapper.py

# Fetch yesterday
python3 algorithms/A8_G\&A_div/Daniel\ Personal/Daniel_communications/code/02_fetch_limitless_wrapper.py yesterday

# Fetch specific date
python3 algorithms/A8_G\&A_div/Daniel\ Personal/Daniel_communications/code/02_fetch_limitless_wrapper.py 2025-11-04

# Fetch last 7 days
python3 algorithms/A8_G\&A_div/Daniel\ Personal/Daniel_communications/code/02_fetch_limitless_wrapper.py --range 7

# Fetch date range
python3 algorithms/A8_G\&A_div/Daniel\ Personal/Daniel_communications/code/02_fetch_limitless_wrapper.py --from 2025-11-01 --to 2025-11-07
```

## 💬 Ask Claude Code

```
Get my Limitless conversations from yesterday
```

```
Show me all Limitless chats from last week
```

```
Fetch conversations from 2025-11-04
```

## 📁 Output Location

```
algorithms/A8_G&A_div/Daniel Personal/Daniel_communications/calls/{date}/
├── 00_summary.md                    # Knowledge Framework summary
├── 00_full_transcript.json          # Raw API response
├── 00_all_conversations_full.md     # All conversations combined
└── conversations/                   # Individual conversation files
    ├── 01_Daily_insights_chat_abc.md
    ├── 02_Longevity_research_chat_def.md
    └── ...
```

## 🔑 API Configuration

**API Key Location:** `.env` at repository root

```bash
LIMITLESS_API_KEY="your_key_here"
```

**Timezone:** PST (America/Los_Angeles) by default

## 📊 Features

✅ Fetch conversations for any date or date range
✅ PST timezone support
✅ Knowledge Framework structured summaries
✅ Theme auto-detection (Daily Insights, Longevity, M&A, Team Management)
✅ Individual conversation extraction
✅ Full transcript preservation

## 🔍 Quick File Access

**Wrapper script:**
```
algorithms/A8_G&A_div/Daniel Personal/Daniel_communications/code/02_fetch_limitless_wrapper.py
```

**Documentation:**
- Full guide: `.claude/skills/limitless-conversations/SKILL.md`
- README: `.claude/skills/limitless-conversations/README.md`

## ⚡ Example Workflow

1. Ask Claude Code: "Get my Limitless conversations from yesterday"
2. Claude fetches conversations via API
3. Creates Knowledge Framework summary
4. Extracts individual conversations
5. Reports statistics:
   - Total conversations
   - Message counts
   - Theme distribution
6. All files saved to `calls/{date}/` directory

## 📝 Notes

- All dates are in PST timezone
- Summaries follow Knowledge Framework principles (MECE, BFO, DRY)
- Files use numeric prefixes per repository standards
- Full API responses preserved for reference
