# Limitless Conversations Skill v2.0

Search and analyze conversations from Limitless.ai - supports both AI assistant chats AND Pendant voice recordings with full transcripts, speaker attribution, and audio download.

## Quick Start

Ask Claude:
```
Get my Limitless lifelogs from yesterday
```

```
Show me Pendant recordings from 2025-11-01 with audio
```

```
Extract both chats and lifelogs for last week
```

## What This Skill Does

### Chats (AI Assistant Conversations)
- 🔍 **Fetch AI chats** by date with PST timezone support
- 📝 **Get summaries** organized by themes and patterns
- ✅ **Extract key decisions** and action items automatically
- 📊 **Analyze patterns** across multiple conversations

### Lifelogs (Pendant Recordings) 🆕
- 🎙️ **Fetch real-world recordings** from Limitless Pendant wearable
- 👥 **Speaker attribution** - identify who said what in conversations
- ⏱️ **Word-level timestamps** - precise timing for every word
- 🎵 **Audio download** - get Ogg Opus audio files (2hr segments)
- ⭐ **Starred moments** - filter and access important recordings
- 📖 **Hierarchical structure** - organized by headings and topics
- 🔄 **Pagination support** - fetch all lifelogs automatically

## Example Output

### Chats Output
```
📅 Chats for 2025-10-30 (PST)

📊 STATISTICS:
- Total conversations: 47
- Total messages: 142
- Daily Insights: 12 conversations
- Longevity Research: 8 conversations
- M&A Negotiations: 5 conversations
```

### Lifelogs Output (NEW!)
```
📅 Lifelogs for 2025-10-30 (PST)

📊 STATISTICS:
- Total recordings: 15
- Identified speakers: 5 (Daniel, Gosha, Unknown, etc.)
- Total duration: 145.3 minutes
- Starred recordings: 3

👥 SPEAKER DISTRIBUTION:
- Daniel: 42 segments, 3847.2s, 5,234 words
- Gosha: 38 segments, 3125.5s, 4,891 words
- Unknown: 12 segments, 892.1s, 1,245 words

🎯 KEY RECORDINGS:

1. Philosophical discussion about free will ⭐
   ID: G1vgXlndou4tzczK1qNv
   Time: 2025-10-30T20:15:00-07:00 - 2025-10-30T22:45:00-07:00
   Speakers: Daniel, Gosha

2. Morning team standup
   ID: abc123def456
   Time: 2025-10-30T09:00:00-07:00 - 2025-10-30T09:30:00-07:00
   Speakers: Daniel, Mike, Ilya

📁 FILES:
- 00_summary.md (Knowledge Framework summary)
- 00_full_lifelogs.json (Raw API response)
- recordings/01_Philosophical_discussion.md
- recordings/02_Morning_standup.md
- audio/01_Philosophical_discussion.opus (if --download-audio)
- audio/02_Morning_standup.opus
```

## Usage Examples

### Command Line

```bash
# Fetch chats only (original functionality)
python3 03_limitless_unified_client.py --mode chats --date 2025-11-04

# Fetch lifelogs (NEW)
python3 03_limitless_unified_client.py --mode lifelogs --date 2025-11-04

# Fetch both chats and lifelogs
python3 03_limitless_unified_client.py --mode both --date 2025-11-04

# Fetch starred lifelogs only
python3 03_limitless_unified_client.py --mode lifelogs --starred

# Fetch lifelogs WITH audio download
python3 03_limitless_unified_client.py --mode lifelogs --date 2025-11-04 --download-audio

# Use different timezone
python3 03_limitless_unified_client.py --mode lifelogs --timezone "Europe/London"
```

### Natural Language (Ask Claude)

```
"Get my Limitless lifelogs from yesterday"
```

```
"Show me all Pendant recordings from last week with speaker analysis"
```

```
"Fetch lifelogs for 2025-11-01 and download audio files"
```

```
"Extract starred lifelogs from this month"
```

## API Key

Automatically loaded from `.env`:
```
LIMITLESS_API_KEY="your_api_key_here"
```

## Output Structure (Updated)

All files saved to:
```
algorithms/A8_G&A_div/Daniel Personal/Daniel_communications/calls/{date}/
├── chats/                              # AI assistant chats
│   ├── 00_summary.md
│   ├── 00_full_transcript.json
│   ├── 00_all_conversations_full.md
│   └── conversations/
│       ├── 01_Daily_insights_chat_abc.md
│       └── 02_Longevity_research_chat_def.md
├── lifelogs/                           # NEW: Pendant recordings
│   ├── 00_summary.md                   # Speaker-aware summary
│   ├── 00_full_lifelogs.json          # Raw lifelog data
│   ├── recordings/                     # Individual lifelog files
│   │   ├── 01_Morning_meeting_abc.md
│   │   └── 02_Gosha_conversation_def.md
│   └── audio/                          # NEW: Audio files (if --download-audio)
│       ├── 01_Morning_meeting_abc.opus
│       └── 02_Gosha_conversation_def.opus
```

## Features Comparison

| Feature | Chats | Lifelogs |
|---------|-------|----------|
| **Data Source** | AI assistant | Pendant wearable |
| **Speaker Attribution** | ❌ | ✅ Yes (name + ID) |
| **Word-Level Timestamps** | ❌ | ✅ Yes (millisecond precision) |
| **Audio Download** | ❌ | ✅ Yes (Ogg Opus, 2hr max) |
| **Hierarchical Structure** | ❌ | ✅ Yes (headings, nested) |
| **Markdown Export** | Plain text | ✅ Full markdown |
| **Starred Filtering** | ❌ | ✅ Yes |
| **Pagination** | ❌ | ✅ Automatic |

## Advanced Features

### Speaker Analysis (Lifelogs)
- Automatic speaker identification
- Speaking time per speaker
- Word count per speaker
- Conversation flow analysis

### Audio Capabilities (Lifelogs)
- Download Ogg Opus audio files
- Maximum 2-hour segments (API limit)
- Direct binary format (no transcoding)
- Synchronized with transcript timestamps

### Hierarchical Content (Lifelogs)
- Content organized by heading levels
- Parent-child relationships
- Semantic navigation
- Topic-based sections

### Starred Moments (Lifelogs)
- Filter important recordings
- Quick access to key insights
- Priority-based retrieval

## Files

- **SKILL.md** - Complete technical documentation
- **01_API_CAPABILITIES_ANALYSIS.md** - Comprehensive API comparison (chats vs lifelogs)
- **00_QUICK_REFERENCE.md** - Quick command reference
- **Clients:**
  - `00_process_conversations.py` - Original chats client
  - `02_fetch_limitless_wrapper.py` - Enhanced chats wrapper
  - `03_limitless_unified_client.py` - NEW: Unified chats + lifelogs client

## MCP Integration (Optional)

For seamless Claude Desktop integration, install MCP server:

```json
{
  "mcpServers": {
    "limitless": {
      "command": "npx",
      "args": ["-y", "@ipvr9/mcp-limitless-server"],
      "env": {
        "LIMITLESS_API_KEY": "your_key"
      }
    }
  }
}
```

This enables natural language queries like:
```
"Show me my conversations about longevity from last week"
```

See `01_API_CAPABILITIES_ANALYSIS.md` for detailed MCP setup.

## What's New in v2.0

✅ Lifelogs (Pendant recordings) support
✅ Speaker attribution with statistics
✅ Word-level timestamps
✅ Audio download capability (Ogg Opus)
✅ Hierarchical content structure
✅ Starred lifelogs filtering
✅ Automatic pagination
✅ Unified client for both data types
✅ Comprehensive API comparison documentation

## Version

**v2.0** (2025-01-15) - Added lifelogs support, speaker attribution, audio download
**v1.0** (2025-01-15) - Initial release with chats support

## See Also

- **Complete API Analysis**: `01_API_CAPABILITIES_ANALYSIS.md`
- **Technical Details**: `SKILL.md`
- **Quick Reference**: `00_QUICK_REFERENCE.md`
