# Limitless Daily Summary Skill - Quick Start

Complete workflow for processing Limitless Pendant recordings into Knowledge Framework summaries.

## Quick Commands

```bash
# Process today
cd "algorithms/A8_G&A_div/Daniel Personal/Daniel_communications/code"
python 03_limitless_unified_client.py --mode lifelogs --date $(date +%Y-%m-%d)
python 08_create_llm_daily_summary.py --date $(date +%Y-%m-%d)

# Process specific date
python 03_limitless_unified_client.py --mode lifelogs --date 2025-11-08
python 08_create_llm_daily_summary.py --date 2025-11-08

# With deduplication
python 05_deduplicate_recordings.py --date 2025-11-08 --dry-run  # Check first
python 05_deduplicate_recordings.py --date 2025-11-08            # Remove dupes
```

## What You Get

**1. Individual Recordings:**
```
YYYY-MM-DD_HH:MM-HH:MM_Topic_Title.md
```

**2. LLM-Based Daily Summary:**
- **Real semantic analysis** by Gemini 2.0 Flash (not keyword counting)
- **3 Mermaid diagrams** with actual topic names
- **Concept taxonomy** - real discussion themes extracted by LLM
- **Event taxonomy** - chronological flow (Morning/Afternoon/Evening)
- **Notable moments** - genuinely interesting topics identified
- **90+ clickable links** to original recordings (Cmd+Click in Cursor/VS Code)
- **Session ID attribution**

## Output Structure

```
calls/2025-11-08/
└── lifelogs/
    ├── 00_daily_summary.md           # Your main summary
    ├── 00_full_lifelogs.json
    └── recordings/
        ├── 2025-11-08_06:00-06:05_Morning_meeting.md
        ├── 2025-11-08_14:30-14:45_Client_call.md
        └── ...
```

## See SKILL.md for Complete Documentation
