# Notion Tasks Analyzer Skill

Unified skill for analyzing Notion tasks - zero inbox, critical tasks, and backlog health.

## Quick Start

```bash
# Check what needs attention
"What should I work on today?"

# Zero inbox
"Show my zero inbox"
"What tasks need scheduling?"

# Critical tasks
"Show critical tasks"
"What's urgent?"

# Full analysis
"Analyze my tasks"
```

## Features

### 1. Zero Inbox Analysis
- Tasks without Focus dates
- Tasks due today or overdue
- Priority breakdown
- Age distribution

### 2. Critical Tasks Analysis
- Critical priority tasks
- Due today, overdue, or unscheduled
- Sorted by age (oldest first)
- Direct Notion URLs

### 3. Combined Task Health
- Overall backlog metrics
- Priority distribution
- Aging analysis
- Actionable recommendations

## Setup

Add to `.env`:
```bash
NOTION_TOKEN="secret_..."
NOTION_YOUR_EMAIL="your.email@improvado.io"
```

## Output Example

```
📥 ZERO INBOX: 15 tasks need Focus dates
🔴 CRITICAL: 3 urgent tasks

Recommendations:
1. Handle 3 critical tasks first
2. Schedule 15 unscheduled tasks
3. Review tasks >30 days old
```

## Related Skills

- `notion-tasks-operations` - Create/update tasks
- `claude-code-sessions` - Search past sessions
- `fireflies-calls` - Call transcripts

## Version

v1.0 (Nov 2025) - Unified analyzer (merged 3 skills)
