# Skill Release Log: notion-tasks-operations

> **Self-Healing Skill Protocol:** This log tracks all skill updates, bug fixes, and new capabilities. Each entry includes session ID, change type, and the issue that triggered the update.

---

## [1.5.0] - 2026-02-13
**Session ID:** Current session by Mikhail Molchanov
**Type:** Feature - Customer Relation Support
**Changes:**
- Added `customer` parameter to `create_task()` in `task_commands.py` and `NotionAgent` wrapper
- Added `find_customer_by_name()` function that searches Customers DB (`43a432c058404db8b70aa8974aa984fc`) by name
- Search logic: exact title match first, then contains fallback
- Added `--customer` / `-c` CLI option to `create-task` command
- Added CRITICAL rule in SKILL.md: Customer field MUST be set for customer-related tasks
- Exported `find_customer_by_name` and `CUSTOMERS_DB_ID` from `notion_cli.py` wrapper
**Issue:** Customer field was frequently missing on tasks created via agent, breaking downstream analytics (call taxonomy linking, hierarchy management). Reported by Roman Vinogradov - example: T-Mobile MDG task without Customer relation.

---

## [1.4.0] - 2025-12-03
**Session ID:** Current session by Daniel Kravtsov
**Type:** Feature - Table Extraction
**Changes:**
- Added `scripts/01_extract_table.py` for fast table extraction from Notion pages
- Supports multiple formats: markdown (default), json, csv, raw
- Auto-detects tables inside toggles, columns, and nested blocks
- URL parsing: extracts page_id and block_id from Notion URLs with anchors
- Added 4 new tests for table extraction (TestTableExtraction class)
- Total tests: 15 (was 11)
**Issue:** User requested quick way to extract tables from Notion pages. Previous workflow required manual API calls.

---

## [1.3.0] - 2025-12-03
**Session ID:** Current session by Daniel Kravtsov
**Type:** Major Refactor - Knowledge Framework Compliance
**Changes:**
- Complete SKILL.md rewrite following Knowledge Framework principles
- Added 2 Mermaid diagrams: Continuant (TD) for architecture, Occurrent (LR) for workflow
- Added Core Principle statement
- Added Ontological Rule
- Added Ground Truth attribution with session IDs
- MECE sections with ¶-numbering: When to Use, Block Operations, Task Operations, Environment, Patterns, Tests
- Reduced from ~900 lines to ~225 lines (75% reduction!) while preserving all functionality
- Added `allowed-tools` to YAML frontmatter
- Created test suite: `tests/01_test_notion_operations.py` (11 tests)
- Tests cover: block ID extraction, append_blocks_after(), Mermaid/Callout/Heading blocks
**Issue:** SKILL.md was verbose and didn't follow Knowledge Framework style. User requested proper KF refactor with tests.

---

## [1.2.0] - 2025-12-03
**Session ID:** Current session by Daniel Kravtsov
**Type:** Feature - Append Blocks After Specific Block + Self-Healing Protocol
**Changes:**
- Added `append_blocks_after()` function for inserting blocks at specific positions in Notion pages
- Added block ID extraction pattern from URL anchors (`page#block-id` → API format with dashes)
- Added self-healing skill protocol (header + footer) to SKILL.md
- Added trigger phrase "append to Notion page" to skill description
- Added version history with all releases
- Added reference to Notion API "after" parameter documentation
- Real-world example: Gong-to-Jira-Notion skill uses this to insert Mermaid diagrams after specific sections
**Issue:** User requested to add Mermaid diagram to Notion page after specific block (URL with anchor `#2bf9aec6...`). Skill didn't have pattern for positional insertion - only appending to end.

---

## [1.1.0] - 2025-11-17
**Session ID:** `2025-11-17` (Ralph Wiggum plugin installation) by Daniel Kravtsov
**Type:** Enhancement - Scope Clarification
**Changes:**
- Added explicit scope limitation: "ONLY for Tasks Database operations"
- Added anti-pattern: "NOT for reading arbitrary Notion pages/documents"
- Added Tasks DB ID to description for clarity
- Added ✅/❌ usage boundary sections
- Created decision tree in CLAUDE.md §5.4 (task management vs content extraction)
- Added working code example for reading arbitrary pages with `NotionClient.get_block_children()`
**Issue:** Claude incorrectly used this skill to read arbitrary Notion pages. User asked "почему ты не использовала notion skill сразу?" - skill description was ambiguous about scope.

---

## [1.0.0] - 2025-01-15
**Session ID:** Initial release
**Type:** Initial Release - NotionAgent Modular Architecture
**Changes:**
- Task management (create, query, update status)
- User management (find, list, whoami, auto-assignment via NOTION_YOUR_EMAIL)
- Tree navigation (bidirectional traversal with parent/child depth)
- Mermaid diagram support in Notion pages
- YouTube timestamp links pattern
- Pattern: Clickable links in task descriptions
- Pattern: Partial task updates (don't replace entire content)
**Issue:** Need centralized skill for Notion Tasks Database operations

---

## Ground Truth

**Source Files:**
- `data_sources/notion/notion_client.py` - Core Notion API client
- `data_sources/notion/notion_cli.py` - NotionAgent CLI wrapper
- `data_sources/notion/markdown_to_blocks.py` - Markdown to Notion blocks converter

**Related Skills:**
- `notion-tasks-analyzer` - Query and analyze tasks
- `gong-to-jira-notion` - Uses append_blocks_after() for Mermaid insertion

**Document Metadata:**
- Skill name: notion-tasks-operations
- Current version: 1.5.0
- Last updated: 2026-02-13
- Maintainer: Daniel Kravtsov (daniel@improvado.io)
