---
name: session-summary
description: Summarize Claude Code sessions in Knowledge Framework format with key actions, files, and outcomes. Use when user says "summarize session", "session summary", or asks what happened in the current session.
---

# Session Summary

**Triggers:** "summarize session", "session summary", "what happened in session"

**Action:** Summarize Claude Code session in Knowledge Framework style with prominent file lists.

**Related:** Browser dashboard at `data_sources/claude_code/26_session_monitor_browser.py`

## Python Parser

Extract files from session:
```bash
python .claude/skills/session-summary/parse_session_files.py <session_id>
```

Returns modified and read file lists.

## Prompt

```
Analyze this Claude Code session and create ultra-concise summary.

**Format:**
## Session: [One-line task description]

**Files Modified:**
- file1.py
- file2.md

**Files Read:**
- config.json
- README.md

**Key Actions:**
- Action 1
- Action 2

**Status:** ✅ Complete / ⚠️ In Progress / ❌ Failed

**Rules:**
- MECE structure (mutually exclusive, collectively exhaustive)
- Thesis = main task
- 50-100 words MAX
- Extract files from tool_use/function_call events in JSONL
- Reference: How to organize documents_knowladge_framework.md

Session log: [path or content]
```

## Usage

```bash
# Summarize current session
/session-summary

# Summarize specific session
/session-summary [session_id]
```

## Output Example

```markdown
## Session: Browser-based session monitor implementation

**Files Modified:**
- 26_session_monitor_browser.py
- 26_summary_prompt.txt
- 26_README_SESSION_MONITOR.md

**Files Read:**
- simple_session_utils.py
- history.jsonl

**Key Actions:**
- Created HTTP server with 10s polling
- Integrated Claude Code CLI for AI summaries
- Added support for both .claude and .codex log formats

**Status:** ✅ Complete
```

## Notes

- Uses Knowledge Framework principles
- Prioritizes file visibility
- Minimal token usage (~200 tokens)
- Mermaid diagrams only if critical
