---
name: sync-claude-session-git
description: Share Claude Code sessions between users via Git. Use when user says "push session", "share my session", "pull session from X", "get session from X", "дай сессию", "запушь сессию", "list sessions", "покажи сессии".
user-invocable: true
argument-hint: "[push|pull <user>|list]"
---

# Session Sync — Share Sessions via Git

Shares Claude Code sessions between team members using an orphan git branch `claude-sessions`. No external services required.

## Script Location

`.claude/scripts/claude_code_session_sync_with_git.py`

## Commands

### Push current session
```bash
python3 .claude/scripts/claude_code_session_sync_with_git.py push --desc "description of what was done"
```
Uploads current session .jsonl to git branch `claude-sessions` with metadata.

### Pull session (latest from user) — auto-launches in new terminal
```bash
python3 .claude/scripts/claude_code_session_sync_with_git.py pull "User Name"
```
Gets the **latest** session from that user, installs to `~/.claude/projects/`, **opens new terminal with `claude --resume`**.

Use `--no-launch` to skip auto-launch:
```bash
python3 .claude/scripts/claude_code_session_sync_with_git.py pull "User Name" --no-launch
```

### Pull session by ID
```bash
python3 .claude/scripts/claude_code_session_sync_with_git.py pull abc123
```
Pulls specific session by ID prefix, launches in new terminal.

### List all shared sessions
```bash
python3 .claude/scripts/claude_code_session_sync_with_git.py list
python3 .claude/scripts/claude_code_session_sync_with_git.py list --user "User Name"
```

## Shell Alias

After running `setup_common_global_claude_code.sh`:
```bash
session-sync push --desc "my work"
session-sync pull "Daniel Kravtsov"
session-sync list
```

## Typical User Requests

- **"запушь мою сессию"** → run `push` with a description of what was accomplished
- **"дай сессию от Daniel"** → run `pull "Daniel Kravtsov"` — auto-launches in new terminal
- **"дай последнюю сессию от Mikhail"** → run `pull "Mikhail Molchanov"`
- **"покажи все сессии"** → run `list`
- **"какие сессии есть у Ilia?"** → run `list --user "Ilia Kolesnikov"`

## How It Works

1. Sessions stored as `.jsonl` files on orphan branch `claude-sessions` (isolated from main)
2. `index.json` on that branch tracks metadata (user, date, description, project)
3. Push/pull uses `git worktree` in `/tmp/` — never touches working tree or uncommitted files
4. Auto-fetches from remote before pull/list
5. After pull: auto-opens new Terminal/iTerm2 window with `claude --resume`

## Setup for New Users

No special setup needed — just clone the repo. The orphan branch `claude-sessions` is fetched automatically.

Optional: run `./setup_common_global_claude_code.sh` to get `session-sync` shell alias.
