---
name: tmux-agents-multi-session
description: Launch Claude Code workers in tmux sessions. Use when user says "launch agent in tmux", "create worker session", "run parallel Claude", "запусти агента в tmux". Works via Bash (always) or MCP (if connected).
version: "2.0.0"
---

## Tmux Multi-Session = Parallel Claude Code Workers

**Thesis:** Launch Claude Code в изолированных tmux сессиях → Отправляй команды → Читай output → Показывай окно пользователю.

```mermaid
graph LR
    A[Create Session] --> B[Launch Claude]
    B --> C[Open Window for User]
    C --> D[Send Commands]
    D --> E[Read Output]
    E --> F[Monitor/Cleanup]
```

---

### ¶1 Quick Start (Bash - работает ВСЕГДА)

**Создать worker:**
```bash
tmux new-session -d -s claude-worker -c ~/projects/chrome-extension-tcs \
  "claude code --dangerously-skip-permissions"
```

**Открыть окно пользователю:**
```bash
# Kitty (рекомендуется):
/Applications/kitty.app/Contents/MacOS/kitty --single-instance -e tmux attach -t claude-worker &

# Или Terminal.app:
osascript -e 'tell application "Terminal" to do script "tmux attach -t claude-worker"'

# Или iTerm2:
osascript -e 'tell application "iTerm" to create window with default profile' \
  -e 'tell application "iTerm" to tell current session of current window to write text "tmux attach -t claude-worker"'
```

**Отправить команду:**
```bash
tmux send-keys -t claude-worker "Найди все TODO в проекте" Enter
```

**Прочитать output:**
```bash
tmux capture-pane -t claude-worker -p | tail -30
```

**Список сессий:**
```bash
tmux list-sessions
```

**Убить сессию:**
```bash
tmux kill-session -t claude-worker
```

---

### ¶2 MCP Tools (если подключен)

**Проверка:** `/mcp` должен показать `tmux ✔ connected`

**⚠️ КРИТИЧНО для Apple Silicon:** MCP по умолчанию может запускаться под Rosetta!

**Установка с ARM64 (ОБЯЗАТЕЛЬНО на Apple Silicon):**
```bash
claude mcp add-json "tmux" '{"command":"arch","args":["-arm64","npx","-y","tmux-mcp"]}'
# Затем ПЕРЕЗАПУСТИТЬ Claude Code!
```

**Старая установка (❌ НЕ ИСПОЛЬЗОВАТЬ на Apple Silicon):**
```bash
# НЕ ДЕЛАЙ ТАК - будет Rosetta!
claude mcp add-json "tmux" '{"command":"npx","args":["-y","tmux-mcp"]}'
```

**MCP инструменты:**
| Tool | Bash эквивалент |
|------|-----------------|
| `mcp__tmux__create_session` | `tmux new-session -d -s name` |
| `mcp__tmux__execute_command` | `tmux send-keys -t name "cmd" Enter` |
| `mcp__tmux__capture_pane` | `tmux capture-pane -t name -p` |
| `mcp__tmux__list_sessions` | `tmux list-sessions` |
| `mcp__tmux__kill_session` | `tmux kill-session -t name` |

**Важно:** MCP подключается только при старте Claude Code. Если не подключен - используй Bash!

---

### ¶3 Defaults (если пользователь не указал)

| Setting | Default |
|---------|---------|
| Directory | `~/projects/chrome-extension-tcs` |
| Flags | `--dangerously-skip-permissions` |
| Session name | `claude-worker`, `claude-worker-2`, ... |

---

### ¶4 Multi-Worker Pattern

```bash
# Создать 3 workers
for i in 1 2 3; do
  tmux new-session -d -s "claude-worker-$i" -c ~/projects/chrome-extension-tcs \
    "claude code --dangerously-skip-permissions"
done

# Открыть все для пользователя (Kitty)
for i in 1 2 3; do
  /Applications/kitty.app/Contents/MacOS/kitty --single-instance -e tmux attach -t "claude-worker-$i" &
  sleep 1
done

# Отправить разные задачи
tmux send-keys -t claude-worker-1 "Fix type errors in data_sources/" Enter
tmux send-keys -t claude-worker-2 "Write tests for auth module" Enter
tmux send-keys -t claude-worker-3 "Update documentation" Enter

# Мониторить все
for i in 1 2 3; do
  echo "=== Worker $i ==="
  tmux capture-pane -t "claude-worker-$i" -p | tail -10
done
```

---

### ¶5 Apple Silicon (M1/M2/M3) - ВАЖНО!

**Проблема:** На Mac с Apple Silicon может быть ДВА Homebrew:
- `/opt/homebrew/bin/tmux` → ARM64 (native) ✅
- `/usr/local/bin/tmux` → x86_64 (Rosetta) ❌

**Проверка:**
```bash
file $(which tmux)
# Должно быть: arm64, НЕ x86_64
```

**Если x86_64 (Rosetta):**
```bash
# Удалить Intel версию
rm /usr/local/bin/tmux
rm -rf /usr/local/Cellar/tmux
```

**Для скриптов/launchd** всегда используй полный путь:
```bash
/opt/homebrew/bin/tmux new-session -d -s session-name ...
```

---

### ¶6 Troubleshooting

| Проблема | Решение |
|----------|---------|
| MCP не подключен | Используй Bash, или перезапусти Claude Code |
| Окно не открывается | `tmux attach -t session` вручную |
| Session exists | `tmux kill-session -t name` и создай заново |
| Нет output | Подожди 3-5 сек после запуска Claude Code |
| Rosetta (x86_64) в tmux | Удали `/usr/local/bin/tmux`, используй `/opt/homebrew/bin/tmux` |
| MCP создаёт x86_64 сессии | Переустанови MCP с `arch -arm64` (см. ¶2) |
| `uname -m` = x86_64 в сессии | Убей сессию, создай через Bash с `/opt/homebrew/bin/tmux` |

---

**Source:** `algorithms/A8_G&A_div/Daniel Personal/mac_os/03_tmux_claude_code_mcp.md`
**Version:** 2.1.0
<!-- 2026-01-03: Fixed MCP Rosetta issue with arch -arm64 -->
