# Upload Session to Drive - Skill Summary

**Quick Description:** Automatically upload current Claude Code session to Google Drive with one command. Handles authentication automatically on first use.

## ⚠️ Prerequisites

**REQUIRED:** `data_sources/google_drive/credentials/credentials.json` with Google Drive API access.

See [data_sources/google_drive/00_README.md](../../../data_sources/google_drive/00_README.md) for setup instructions.

## When to Use

- Share conversation context with colleagues
- Archive important sessions
- Collaborate on complex implementations
- Document decision-making process
- Create knowledge base from sessions

## How It Works

1. **Auto-detects** current session ID
2. **Authenticates** Google Drive (browser on first use, cached after)
3. **Uploads** session .jsonl file
4. **Optionally shares** with email address
5. **Returns** shareable Drive link

## Usage

**Simple upload:**
```
User: "Upload this session to Drive"
→ Opens browser for auth (first time only)
→ Uploads session
→ Returns link
```

**Upload and share:**
```
User: "Upload this session and share with colleague@example.com"
→ Uses cached token (no browser!)
→ Uploads and shares
→ Returns link + confirmation
```

## First Time Setup

**Automatic!** Just invoke the skill:
1. Skill detects no token exists
2. Opens browser for Google OAuth
3. You authorize access
4. Token saved for future use
5. Upload proceeds automatically

**Future uses:** Fully automatic (no browser)

## Key Features

- ✅ **Auto-authentication** - Browser only on first use
- ✅ **Token caching** - Subsequent runs instant
- ✅ **Auto token refresh** - Expired tokens refreshed automatically
- ✅ **Email sharing** - Optional recipient with notification
- ✅ **Session metadata** - Includes cwd, git branch, version info
- ✅ **Error handling** - Clear messages for troubleshooting

## Technical Details

**Session Location:**
```
~/.claude/projects/{encoded-path}/{session-id}.jsonl
```

**Credentials:**
```
data_sources/google_drive/credentials/
├── credentials.json  # OAuth client (from Google Cloud Console)
└── token.pickle     # Auto-generated token (cached)
```

**Python Script:**
```
.claude/skills/upload-session-to-drive/upload_session.py
```

## Quick Test

Run manually to test:
```bash
python3 .claude/skills/upload-session-to-drive/upload_session.py

# With email sharing:
python3 .claude/skills/upload-session-to-drive/upload_session.py colleague@example.com
```

## Troubleshooting

**Issue:** "Credentials file not found"
**Solution:** Place credentials.json in `data_sources/google_drive/credentials/`

**Issue:** Token expired
**Solution:** Delete `token.pickle` and run again (browser will reopen)

**Issue:** Session not found
**Solution:** Check session ID with `/get_session_id`

## Related

- **Get session ID:** `/get_session_id` command
- **Drive client:** `data_sources/google_drive/drive_client.py`
- **Session management:** `data_sources/claude_code/21_universal_session_resume.py`
