# YouTube to Knowledge Documentation Skill

## Quick Start

Convert any YouTube video to structured Knowledge Framework documentation:

```
User: "Document this video: https://www.youtube.com/watch?v=VIDEO_ID"
```

## What It Does

1. **Extracts transcript** using yt-dlp
2. **Gets Claude Code session ID** using get_session_id.py (MANDATORY for attribution)
3. **Analyzes content** to determine appropriate folder
4. **Recommends location** based on topic (AI Agent, Architecture, Market Research, etc.)
5. **Generates structured doc** with:
   - MECE sections (1.0, 2.0, 3.0)
   - Mermaid diagrams (Continuant TD + Occurrent LR)
   - Ground truth attribution (YouTube URL, timestamps, session ID)
   - Paragraph numbering (¶1, ¶2, ¶3)

## Example Output

Created document: `algorithms/product_div/Ai Agent/02_anthropic_introspection_research.md`

**Structure:**
- Thesis: One sentence previewing all sections
- Overview: Paragraph introducing major sections + Session ID
- Continuant diagram: Research structure (TD)
- Occurrent diagram: Experimental flow (LR)
- Section 1.0: Experimental Methodology
- Section 2.0: Consciousness Implications
- Section 3.0: Future Implications
- Author Checklist: Validation completed

**Session ID attribution:**
```markdown
**Generated by:** Claude Code session `21fc9ab9-7ffd-40b7-9cac-1a5570f86e7d` by Daniel Kravtsov (2025-11-10)
```

## Dependencies

- **yt-dlp** (already installed in chrome-extension-tcs)
- **Knowledge Framework guide** (How to organize documents_knowladge_framework.md)
- **folder-finder skill** (determines target location)

## Usage Examples

### AI Research Video
```
"Document https://www.youtube.com/watch?v=ABC123"
→ algorithms/product_div/Ai Agent/NN_topic_name.md
```

### Market Analysis
```
"Create notes from this Gartner webinar: URL"
→ algorithms/product_div/market_research/NN_analysis_name.md
```

### Personal Learning
```
"I watched a tutorial, want to document it: URL"
→ algorithms/A8_G&A_div/Daniel Personal/NN_tutorial_topic.md
```

## Quality Standards

✅ MECE sections (Mutually Exclusive, Collectively Exhaustive)
✅ Mermaid diagrams (minimum 1, complex topics need 2)
✅ Ground truth attribution with timestamps
✅ Paragraph numbering (¶1, ¶2, ¶3)
✅ Session ID and author attribution
✅ Author Checklist completed

## File Naming

Pattern: `NN_descriptive_topic_name.md`

Examples:
- `02_anthropic_introspection_research.md`
- `03_gartner_ai_agent_market_2025.md`
- `04_multi_agent_orchestration_patterns.md`

## See Also

- **SKILL.md** - Complete implementation guide
- **folder-finder skill** - Folder selection logic
- **How to organize documents_knowladge_framework.md** - Documentation standards
