# Coaching Techniques Reference

Detailed methodology guides for effective founder coaching conversations.

## Growth Mindset in Coaching (Carol Dweck Research)

### The Core Finding

35+ years of research shows that **how you praise matters more than how much you praise**.

**[Mueller & Dweck (1998)](https://doi.org/10.1037/0022-3514.75.1.33)** - *Journal of Personality and Social Psychology* - 5th graders given different types of praise:
- **Trait praise** ("You must be smart"): Students avoided challenges, lost confidence when struggling, performance declined, 38% lied about scores
- **Process praise** ("You must have worked hard"): Students sought challenges, persisted through difficulty, performance improved

### Fixed vs. Growth Mindset

| Fixed Mindset | Growth Mindset |
|--------------|----------------|
| Intelligence/ability is static | Intelligence/ability grows with effort |
| Avoids challenges (might fail) | Seeks challenges (opportunity to grow) |
| Effort = you're not smart enough | Effort = path to mastery |
| Gives up when stuck | Persists through obstacles |
| Ignores useful feedback | Learns from criticism |
| Threatened by others' success | Inspired by others' success |

### How Coaching Language Shapes Mindset

**Fixed mindset triggers:**
- "You're a natural entrepreneur"
- "You're so talented at this"
- "Some people just have it"
- "You're smart enough to figure this out" (implies smartness is fixed)

**Growth mindset triggers:**
- "Your strategy here was effective"
- "The effort you put into preparation shows"
- "You've improved significantly since we last talked"
- "What did you learn from that setback?"

### Reframing Struggle as Growth

**Fixed mindset view:** Struggle = evidence of inadequacy
**Growth mindset view:** Struggle = evidence of learning happening

**Coaching reframes:**
- "Finding this hard means you're pushing your boundaries"
- "Confusion is often the first step to understanding"
- "The fact that you're stuck shows you're tackling something meaningful"
- "What's one thing this challenge is teaching you?"

### The Effort Paradox

**Warning:** Praising effort alone can backfire if the effort isn't effective.

**Ineffective:** "You tried really hard!" (when strategy was wrong)
**Effective:** "You tried multiple approaches—what did you learn about which ones work?"

The goal is to praise **effective effort**—effort that involves good strategies, seeking help, and learning from mistakes.

### Application to Founder Coaching

| Situation | Fixed Mindset Response (Avoid) | Growth Mindset Response (Use) |
|-----------|-------------------------------|------------------------------|
| Founder succeeds | "You're a great founder" | "Your approach to customer discovery was methodical" |
| Founder fails | "Maybe this isn't for you" | "What did this teach you? How will you adjust?" |
| Founder is stuck | "You should be able to figure this out" | "Getting stuck on hard problems is normal. What have you tried?" |
| Founder avoids challenge | "That's okay, play to your strengths" | "What would you learn by trying it anyway?" |

## GROW Model

The most widely-used coaching framework, developed by Sir John Whitmore.

### Structure

**G - Goal**: What do you want to achieve?
**R - Reality**: Where are you now?
**O - Options**: What could you do?
**W - Will**: What will you do?

### Goal Questions

Start by establishing what the founder wants from this conversation and longer-term:

- "What would you like to focus on today?"
- "What does your ideal future look like?"
- "Over what time frame?"
- "How will you know when you've achieved it?"
- "What would make this session well-spent?"

**Keys to Good Goals**
- Specific enough to measure
- Within founder's control
- Positively stated (what they want, not what they don't want)
- Time-bound

### Reality Questions

Understand current situation without judgment:

- "Where are you now on a scale of 1-10?"
- "What's happening at the moment?"
- "What have you tried so far?"
- "Who else is involved?"
- "What's stopping you from being at a 10?"
- "What resources do you have?"
- "What's worked before in similar situations?"

**Purpose**: Create accurate assessment, surface assumptions, identify resources already available.

### Options Questions

Generate possibilities without evaluating yet:

- "What could you do?"
- "What else?" (ask 3-5 times)
- "If you had no constraints, what would you do?"
- "What would you advise a friend in this situation?"
- "What are the advantages and disadvantages of each option?"
- "What would happen if you did nothing?"
- "Who else might help?"

**Rules**
- Quantity over quality first
- No evaluation during brainstorming
- Include wild/unlikely options
- Ask "what else?" until genuinely stuck

### Will Questions

Convert options into specific commitments:

- "What will you do?"
- "When exactly will you do it?"
- "What obstacles might you meet?"
- "How will you overcome them?"
- "Who needs to know?"
- "What support do you need?"
- "How committed are you on a scale of 1-10?"
- "What would make it a 10?"

**Commitment Checklist**
- Is it specific?
- Is there a deadline?
- Are obstacles anticipated?
- Is commitment level high (8+)?

## Solution-Focused Brief Coaching

Developed by Steve de Shazer and Insoo Kim Berg. Core philosophy: Focus on solutions, not problems.

### Core Principles

1. **If it ain't broke, don't fix it**
2. **Once you know what works, do more of it**
3. **If it's not working, do something different**

### The Miracle Question

**"Suppose tonight while you sleep, a miracle happens. The problem is solved. When you wake up tomorrow, what will be the first small sign that tells you the miracle happened?"**

**Follow-Up Questions**
- "What will be different?"
- "Who will notice first?"
- "What will they see you doing?"
- "What will that make possible?"

**Purpose**: Bypass problem-focus, reveal desired future state, make abstract goals concrete.

### Exception Finding

**"Tell me about a time when this problem wasn't happening, or was less severe. What was different? What were you doing differently?"**

**Follow-Up Questions**
- "How did you make that happen?"
- "What was different about that situation?"
- "How could you do more of that?"

**Purpose**: Identify existing solutions, build on past successes, recognize founder's own resources.

### Scaling Questions

**"On a scale of 1-10, where 10 is the miracle and 1 is the worst it's been, where are you today?"**

**Follow-Ups**
- "What makes it a [current number] and not lower?"
- "What would it take to move from [current] to [current +1]?"
- "When have you been at a higher number?"
- "What was happening then?"

**Purpose**: Make abstract progress concrete, identify small steps, celebrate progress already made.

### Coping Questions

For founders in crisis or overwhelm:

- "How have you managed to keep going despite everything?"
- "What keeps you from giving up?"
- "What's one thing that's still working?"

**Purpose**: Recognize resilience, identify coping resources, shift from helplessness to agency.

## Socratic Method

Named after Socrates. Uses disciplined questioning to stimulate critical thinking and illuminate assumptions.

### Six Types of Socratic Questions

**1. Clarifying Questions**
- "What exactly do you mean by...?"
- "Can you give me an example?"
- "How does this relate to your goal?"
- "What's the connection between X and Y?"

**2. Probing Assumptions**
- "What are you assuming here?"
- "Is that always the case?"
- "What would happen if that assumption were wrong?"
- "What would need to be true for X?"

**3. Probing Reasons and Evidence**
- "What evidence supports that?"
- "How do you know that's true?"
- "What makes you say that?"
- "Is that data or intuition?"

**4. Exploring Viewpoints and Perspectives**
- "How would your co-founder see this?"
- "What's the alternative perspective?"
- "How would this look from your users' view?"
- "What would a skeptic say?"

**5. Examining Implications and Consequences**
- "If you do that, what happens next?"
- "What are the long-term implications?"
- "How does this affect your other goals?"
- "What's the cost of this choice?"

**6. Meta-Questions (Questions about Questions)**
- "Why do you think I asked that?"
- "What other questions should we explore?"
- "What question would be most useful right now?"
- "What are you not asking that you should be?"

### The Funnel Technique

**Start Broad**
"Tell me about the situation you're facing."

**Narrow Focus**
"Of all those factors, which feels most critical?"

**Go Deep**
"What makes that factor so important to you?"

**Surface Insights**
"What are you realizing as we talk through this?"

**Plan Action**
"Given what we've discovered, what's one small step you could take?"

## Michael Bungay Stanier's 7 Essential Questions

From "The Coaching Habit"—designed to stay curious longer and rush to advice less quickly.

### 1. "What's on your mind?" (The Kickstart Question)
- Open-ended, focused
- Gets to what's actually important
- Better than "How are you?"

### 2. "And what else?" (The AWE Question)
- Most important question
- First answer is rarely the real answer
- Prevents rushing to problem-solving
- Ask 3-5 times per conversation

### 3. "What's the real challenge here for you?" (The Focus Question)
- Cuts through complexity
- "Real challenge" = get to the root
- "For you" = makes it personal, not abstract

### 4. "What do you want?" (The Foundation Question)
- Clarifies desired outcome
- Creates autonomy
- Transitions from reflection to action

### 5. "How can I help?" (The Lazy Question)
- Places ownership on the other person
- Prevents assuming you know how to help
- Acceptable responses: Yes/No/Alternative/Let me think

### 6. "If you're saying yes to this, what are you saying no to?" (The Strategic Question)
- Forces prioritization
- Reveals trade-offs
- Creates focus and boundaries

### 7. "What was most useful for you?" (The Learning Question)
- Consolidates learning
- Builds self-awareness
- Improves future sessions

## Radical Candor for Honest Feedback

Kim Scott's framework for giving feedback that's both caring and direct.

### The 2x2 Matrix

|  | Low Challenge | High Challenge |
|---|---|---|
| **High Care** | Ruinous Empathy | **RADICAL CANDOR** ✓ |
| **Low Care** | Manipulative Insincerity | Obnoxious Aggression |

**Ruinous Empathy** is the most common failure mode—being nice instead of being helpful.

### The CORE Method for Criticism

When delivering difficult feedback, use this structure:

- **C**ontext: "In yesterday's investor pitch..."
- **O**bservation: "When you said the market is $50B without citing a source..."
- **R**esult: "The investor visibly disengaged and asked no follow-up questions..."
- **E**xpectation: "Going forward, lead with credible third-party market data."

### Application for Founder Coaching

**Before giving hard feedback:**
1. Check your intent—are you trying to help them succeed?
2. Use CORE structure to be specific, not vague
3. Focus on behavior and results, not character
4. Make it a conversation: "How does that land for you?"

**Common mistakes:**
- The "feedback sandwich" (positive-negative-positive) buries the message
- Adam Grant: "When you start and end with positive feedback, criticism gets buried or discounted"
- Better: Direct feedback followed by "What would help?"

## Powerful Question Characteristics

Research shows effective coaching questions share these traits:

### Open-Ended
- Start with What, How, When
- Avoid Why (too defensive)
- Allow exploration, not yes/no

**Good**: "What options do you see?"
**Bad**: "Do you have options?"

### Future-Focused
- "What do you want to create?"
- "Where do you want to be in 6 months?"
- Not: "Why did this go wrong?"

### Generatively Ambiguous
- Allow client to define terms their own way
- "What does success mean to you?"
- Not: "Do you want to hit $1M ARR?"

### Short and Clean
- 5-10 words ideal
- No metaphors unless client introduces them
- Minimal interference from coach

### Client-Focused, Not Problem-Focused
- "What do you want?"
- "What's working?"
- Not: "What's the problem?" "What's broken?"

## Accountability Structures

### The Accountability Conversation

**Opening (5 minutes)**
1. "What did you commit to last time?"
2. "What actually happened?"
3. If completed: "What did you learn?"
4. If not completed: "What got in the way?" (curious, not judgmental)

**Middle (20 minutes)**
5. "What does that tell you?"
6. "What do you want to do differently?"
7. Continue with GROW or other framework

**Closing (5 minutes)**
8. "What's your commitment for next time?"
9. "On a scale of 1-10, how confident are you?"
10. "What might get in the way?"
11. "How will you handle that?"

### Making Commitments Stick

**SMART Format**
- **Specific**: "Talk to 10 users" not "do user research"
- **Measurable**: Clear success criteria
- **Achievable**: Within founder's control
- **Relevant**: Connected to stated goals
- **Time-bound**: "By Friday" not "soon"

**Obstacle Pre-Mortems**
Before any commitment is made:
- "What might get in the way?"
- "What's happened before when you tried this?"
- "What would make it a 10/10 in commitment?"
- If below 8/10: "What would make it higher?"

### Commitment Devices

Research-backed techniques:
- **Public commitment**: Share goals with someone else
- **Implementation intentions**: "If X happens, I will do Y"
- **Progress documentation**: Visual tracking

## When to Ask vs. When to Tell

### Default to Questions (80%)

**Why Questions Work Better**
- Founder implements THEIR solution, not yours
- Builds decision-making capacity
- You don't have full context
- Creates ownership, not dependency

### When Advice IS Appropriate (20%)

1. Founder explicitly asks: "What would you do?"
2. Safety/legal/ethical considerations
3. Factual information (grants, market data, frameworks)
4. After thorough exploration, founder is genuinely stuck

### How to Give Advice Without Undermining

1. **Ask permission**: "Would it be useful if I shared what I've seen work for others?"
2. **Offer options, not directives**: "Some founders have tried X or Y. What resonates?"
3. **Stay tentative**: "I wonder if..." not "You should..."
4. **Check fit**: "How does that land for you?"
5. **Return to questions**: "What would you adapt from that for your situation?"

## Empowerment Techniques

### Reflect Questions Back

**Founder**: "Should I hire a head of sales?"
**Weak**: "Yes, you should."
**Strong**: "What's making you consider that now?"

### Mine Past Successes

- "When have you faced a similar decision? What did you do?"
- "What's worked for you in the past when you were uncertain?"

### Expand Options

- "What else could you try?"
- "If that option wasn't available, what would you do?"
- "What would [someone they admire] do?"

### Strengthen Decision-Making

- "What criteria matter most here?"
- "What information would help you decide?"
- "How will you know if it's the right call?"

### Build Meta-Cognition

- "What's your thinking process here?"
- "How are you approaching this decision?"
- "What questions are you asking yourself?"

## Anti-Patterns to Avoid

### Solution Dumping
**Problem**: Immediately providing answers
**Fix**: Ask 3 questions before any suggestion

### Vague Questions
**Problem**: "How do you feel about that?"
**Fix**: Specific questions that advance thinking

### Interrupting
**Problem**: Talking more than listening
**Fix**: Target 20% coach, 80% founder

### Making It About You
**Problem**: "When I was building my startup..."
**Fix**: Share sparingly, return to their situation

### Ignoring Emotions
**Problem**: Pure analysis on emotional topics
**Fix**: Acknowledge before problem-solving

### Being Too Nice
**Problem**: Sugar-coating dilutes value
**Fix**: "I want to be direct with you..."

### Generic Advice
**Problem**: Same advice to everyone
**Fix**: Mine their specific context
