# Foundry & Solidity Resources

Authoritative resources for Foundry and Solidity development.

## Official Documentation

### Foundry
- **Foundry Book**: https://book.getfoundry.sh - Comprehensive guide (forge, anvil, cast, chisel)
- **Foundry GitHub**: https://github.com/foundry-rs/foundry - Source code and issues
- **forge-std**: https://github.com/foundry-rs/forge-std - Standard library reference

### Solidity
- **Solidity Docs**: https://docs.soliditylang.org - Language reference
- **Solidity GitHub**: https://github.com/ethereum/solidity - Compiler source
- **Solidity Blog**: https://soliditylang.org/blog - Release notes and features

### Ethereum
- **Ethereum.org Developers**: https://ethereum.org/developers - Developer portal
- **EIPs**: https://eips.ethereum.org - Ethereum Improvement Proposals
- **Ethereum Stack Exchange**: https://ethereum.stackexchange.com - Q&A community

## Smart Contract Libraries

### Production-Ready
- **OpenZeppelin Contracts**: https://docs.openzeppelin.com/contracts - Audited implementations
  - ERC-20, ERC-721, ERC-1155 tokens
  - Access control, pausable, upgradeable
  - Security utilities

- **Solady**: https://github.com/Vectorized/solady - Gas-optimized utilities
  - Used by Coinbase, Optimism, Uniswap
  - Highly optimized ERC implementations

- **Solmate**: https://github.com/transmissions11/solmate - Minimalist implementations
  - Gas-efficient ERC tokens
  - Auth and utility contracts

## Security Resources

### Audit Firms
- **OpenZeppelin Security**: https://www.openzeppelin.com/security-audits
- **Trail of Bits**: https://blog.trailofbits.com
- **Consensys Diligence**: https://consensys.io/diligence

### Crowdsourced Audits
- **Code4rena**: https://code4rena.com - Competitive audits
- **Sherlock**: https://sherlock.xyz - Audit competitions
- **Immunefi**: https://immunefi.com - Bug bounties

### Vulnerability Resources
- **SWC Registry**: https://swcregistry.io - Smart Contract Weaknesses
- **Rekt News**: https://rekt.news - Exploit post-mortems
- **DeFiHackLabs**: https://github.com/SunWeb3Sec/DeFiHackLabs - Exploit reproductions

### Security Tools
- **Slither**: https://github.com/crytic/slither - Static analysis
- **Mythril**: https://mythril.ai - Symbolic execution
- **Echidna**: https://github.com/crytic/echidna - Fuzzing
- **Certora**: https://www.certora.com - Formal verification

## Learning Resources

### Interactive
- **Solidity by Example**: https://solidity-by-example.org - Runnable code examples
- **CryptoZombies**: https://cryptozombies.io - Gamified learning
- **SpeedRun Ethereum**: https://speedrunethereum.com - Hands-on challenges

### Courses
- **Cyfrin Updraft**: https://updraft.cyfrin.io - Patrick Collins courses
- **Alchemy University**: https://university.alchemy.com - Web3 development

### Patterns & Best Practices
- **Solidity Patterns**: https://docs.soliditylang.org/en/latest/common-patterns.html
- **OpenZeppelin Docs**: https://docs.openzeppelin.com/contracts - Implementation guides

## Development Tools

### IDEs & Editors
- **VS Code + Solidity Extension**: https://marketplace.visualstudio.com/items?itemName=JuanBlanco.solidity
- **Remix IDE**: https://remix.ethereum.org - Browser-based

### Testing & Debugging
- **Tenderly**: https://tenderly.co - Transaction debugging
- **Phalcon**: https://explorer.phalcon.xyz - Transaction analysis

### Infrastructure
- **Alchemy**: https://www.alchemy.com - RPC provider
- **Infura**: https://www.infura.io - RPC provider
- **QuickNode**: https://www.quicknode.com - RPC provider

## Community

### Discussion
- **Foundry Telegram**: https://t.me/foundry_rs
- **Ethereum R&D Discord**: https://discord.gg/ethereum-r-d
- **OpenZeppelin Forum**: https://forum.openzeppelin.com

### Research
- **Paradigm Research**: https://www.paradigm.xyz/writing
- **a]16z Crypto Research**: https://a16zcrypto.com/research

## Quick Reference

### Getting Started Path
1. **Solidity by Example** - Learn syntax
2. **Foundry Book** - Learn tooling
3. **OpenZeppelin Docs** - Learn patterns
4. **Code4rena Reports** - Learn security

### Testing Best Practices
1. **forge-std** - Test utilities
2. **Foundry Book Testing** - Fuzz and invariant testing
3. **DeFiHackLabs** - Real exploit patterns

### Security Path
1. **OpenZeppelin Audit Readiness** - Preparation
2. **Trail of Bits Blog** - Deep dives
3. **Code4rena** - Real audit reports

## Version Context

Current versions (November 2025):
- **Foundry**: v1.5.0
- **Solidity**: 0.8.30
- **OpenZeppelin Contracts**: v5.x
- **forge-std**: v1.9.x
