# Revision Frameworks and Editing Science

Research-backed processes for transforming drafts into impactful content.

## Contents
- The Four-Level Editing System
- Revision Strategy Research
- The Conciseness Pass
- Active Voice Conversion
- Before/After Case Studies
- Self-Editing Techniques
- Common Revision Mistakes

## The Four-Level Editing System

### Overview

Professional editors work through four distinct levels, never mixing concerns:

| Level | Focus | Time Investment |
|-------|-------|-----------------|
| 1. Developmental | Structure, content, argument | 30-50% |
| 2. Line | Style, clarity, flow | 25-35% |
| 3. Copy | Grammar, consistency, facts | 20-30% |
| 4. Proofreading | Typos, formatting | 10-15% |

**Critical principle**: Work through levels sequentially. Fixing typos before addressing structure wastes time.

### Level 1: Developmental Editing

**Focus**: Big-picture organization, narrative flow, argument structure

**Questions to ask:**
- What is the core message? (Write it in one sentence)
- Does every section advance this message?
- Is information in logical order?
- Are there gaps in logic or evidence?

**Technique**: Reverse outline
- After drafting, outline what you wrote
- Each paragraph = one bullet
- Gaps and redundancies become visible

### Level 2: Line Editing

**Focus**: Sentence-level improvements, paragraph flow, voice consistency

**Questions to ask:**
- Is this the clearest way to say this?
- Can I say this in fewer words?
- Does each paragraph have one clear focus?
- Are transitions smooth?

**Technique**: Read aloud
- Unclear passages trip your tongue
- Run-on sentences make you gasp for breath
- Awkward phrasing becomes obvious

### Level 3: Copyediting

**Focus**: Grammar, punctuation, style guide adherence, fact-checking

**Questions to ask:**
- Is this grammatically correct?
- Is it consistent with prior usage?
- Are facts and citations accurate?

**Technique**: Separate passes for different concerns
- One pass for punctuation
- One pass for consistency
- One pass for facts

### Level 4: Proofreading

**Focus**: Typos, formatting, layout issues

**Questions to ask:**
- Are there any remaining errors?
- Is formatting consistent?
- Do all links work?

**Technique**: Read backwards
- Forces focus on individual words
- Prevents brain from "filling in" expected text
- Catches typos the eye normally skips

## Revision Strategy Research

### Graham & Perin Meta-Analysis (2007)

Analysis of 123 studies with 154 effect sizes:

| Intervention | Effect Size |
|--------------|-------------|
| Strategy instruction | 0.82 (highest) |
| Sentence combining | 0.50 |
| Process writing | 0.32 |
| Grammar instruction | -0.32 (negative) |

**Key insight**: Teaching explicit revision strategies has nearly triple the impact of teaching grammar rules.

### What "Strategy Instruction" Means

The most effective approach combines:
1. **Cognitive strategies**: Planning, organizing, self-regulation
2. **Metacognitive strategies**: Self-assessment, reflection
3. **Procedural knowledge**: Specific techniques to apply

**Implication**: Having a revision process matters more than knowing grammar rules.

### Timing Research

Studies show separating drafting from editing improves quality:
- Self-assessment before and after revision improves both self-efficacy and writing
- 24-hour gap between drafting and editing recommended (cognitive refresh)
- "Kill your darlings" easier with time distance

## The Conciseness Pass

### Scott Hotaling's Framework (Limnology and Oceanography Letters, 2020)

Three types of filler that reduce conciseness:

**1. Qualifiers (adverbs)**
- Examples: quickly, extremely, frequently, very, really
- Impact: Often add zero information
- Fix: Remove entirely in most cases

**2. Prepositional phrase chains**
- Examples: "in this case," "among other things," "on the other hand"
- Impact: Make sentences jumbled and unclear
- Fix: Replace multi-word phrases with single words

**3. Overused transitions**
- Examples: however, meanwhile, thus, furthermore
- Impact: Create verbal clutter when overused
- Fix: Remove extraneous transitions, combine sentences

### Common Wordy Phrases

| Wordy | Concise | Words Saved |
|-------|---------|-------------|
| due to the fact that | because | 4 |
| in order to | to | 2 |
| at this point in time | now | 4 |
| in the event that | if | 3 |
| with regard to | about | 2 |
| for the purpose of | to | 3 |
| in spite of the fact that | although | 5 |
| it is important to note that | (delete entirely) | 6 |
| the reason why is that | because | 3 |
| until such time as | until | 3 |

### Unnecessary Lead-Ins

| Cut This | Keep This |
|----------|-----------|
| "It is worth noting that the data shows..." | "The data shows..." |
| "In terms of the findings, we see that..." | "We found..." |
| "As far as the analysis is concerned..." | "The analysis..." |
| "With respect to the issue of..." | (State the issue directly) |

### Word Simplification

| Complex | Simple | Syllables Saved |
|---------|--------|-----------------|
| utilize | use | 2 |
| commence | start | 1 |
| terminate | end | 2 |
| demonstrate | show | 2 |
| facilitate | help | 3 |
| subsequently | later | 2 |
| approximately | about | 3 |
| endeavor | try | 2 |
| ascertain | find out | 1 |
| implement | do, use | 2 |

### Compound Effect

Small edits compound across documents:
- 8,000-word document
- 50 phrase simplifications (average 3 words each)
- 150 words saved
- 10-30% length reduction possible

## Active Voice Conversion

### Identification

Passive voice pattern: form of "to be" + past participle

| Passive Indicator | Example |
|-------------------|---------|
| is/was + past participle | "was written" |
| are/were + past participle | "were found" |
| has/have been + past participle | "has been completed" |
| will be + past participle | "will be reviewed" |

### Conversion Process

1. Identify the true actor (who/what performs the action)
2. Make the actor the subject
3. Use active verb form

**Examples:**

| Passive | Active |
|---------|--------|
| The report was written by the team | The team wrote the report |
| Errors were found in the code | We found errors in the code |
| The meeting was scheduled for 3pm | I scheduled the meeting for 3pm |
| A decision was made to proceed | The board decided to proceed |
| The feature has been implemented | We implemented the feature |
| Concerns were raised about costs | Stakeholders raised concerns about costs |

### When to Keep Passive

Keep passive voice only when:
- **Actor unknown**: "The window was broken" (no one knows by whom)
- **Actor irrelevant**: "The samples were collected" (focus on samples, not collector)
- **Object emphasis**: "Three bugs were fixed" (emphasis on bugs)
- **Hedging appropriate**: "Mistakes were made" (deliberately vague)

**Default**: Convert to active unless specific reason to keep passive.

## Before/After Case Studies

### Case Study 1: Legal Court Form

**Original** (complex):
- Average comprehension: 61%
- Sentence length: 28 words average

**Revised** (plain language):
- Average comprehension: 81% (+33%)
- Sentence length: 16 words average
- Length: 40% shorter

**Changes made:**
- Sentence length reduced from 28 to 16 words
- Legal jargon removed: "hereinafter," "aforementioned," "pursuant to"
- Active voice throughout
- Clear headings and white space
- Steps listed numerically

### Case Study 2: Judicial Opinion

**Original:**
> The plaintiff commenced an action in this Court seeking declaratory relief with respect to the issue of whether or not the defendant insurance company has an obligation under the applicable policy provisions to provide coverage for the injuries sustained by the plaintiff in the accident which is the subject matter of this litigation.

(51 words, one sentence)

**Revised:**
> Robert Wills was injured when someone fired shots toward his car, causing him to swerve into a tree. He filed a declaratory-judgment action to determine whether State Farm had to pay him uninsured-motorist benefits.

(35 words, two sentences)

**Results:**
- 61% of lawyers preferred revised version
- Rated 7/10 vs 6/10

### Case Study 3: Technical Documentation

**Before:**
> In order to facilitate the implementation of the authentication functionality, it will be necessary for developers to utilize the OAuth2 library which has been provided in the dependencies folder, ensuring that the appropriate configuration parameters have been set in accordance with the specifications outlined in the configuration documentation.

(53 words)

**After:**
> To add authentication, use the OAuth2 library in the dependencies folder. Set the configuration parameters as described in config.md.

(20 words)

**Improvement:**
- 62% fewer words
- Same information
- Clearer action steps

### Case Study 4: Email Communication

**Before:**
> I am writing to follow up with you regarding the matter we discussed in our previous meeting concerning the upcoming project deliverables. As we discussed, it would be beneficial for us to schedule a time to meet in order to review the current status of the project and to discuss any potential issues that may need to be addressed prior to the deadline.

(68 words)

**After:**
> Can we meet this week to review the project status before the deadline? I want to address any issues early.

(20 words)

**Improvement:**
- 70% fewer words
- Clear action requested
- Specific timeline

## Self-Editing Techniques

### Technique 1: The "So What?" Test

**Application**: After each paragraph, ask "So what?"

If you can't answer clearly, the paragraph needs revision.

**Example:**
> "The system uses a microservices architecture."

So what?

> "The system uses a microservices architecture, so you can update individual components without redeploying everything."

### Technique 2: One Idea Per Sentence

**Application**: If sentence contains "and," "but," or "however," consider splitting.

**Before:**
> "The API is fast and reliable but requires authentication and uses rate limiting."

**After:**
> "The API is fast and reliable. It requires authentication and uses rate limiting."

### Technique 3: Front-Load Subject and Verb

**Application**: First 7-8 words should contain subject and main verb.

**Before:**
> "In order to understand the implications of the proposed changes to the system architecture, developers need to review the documentation."

**After:**
> "Developers need to review the documentation to understand the proposed changes."

### Technique 4: The Grandmother Test

**Application**: Would a non-expert understand the main point?

If not, simplify until they would.

### Technique 5: The Cut Test

**Application**: For each sentence, ask "Can I remove this without losing meaning?"

If yes, remove it.

### Technique 6: Kill Your Darlings

**Application**: Identify your favorite phrases. Evaluate them critically.

Writers overvalue their clever phrasing (overconfidence bias). Favorite phrases often serve the writer's ego, not the reader's understanding.

### Technique 7: Convert Nominalizations

**Application**: Change noun phrases back to verbs.

| Nominalization | Verb Form |
|----------------|-----------|
| made an investigation into | investigated |
| reached a conclusion about | concluded |
| gave consideration to | considered |
| performed an analysis of | analyzed |
| made a decision to | decided to |

### Technique 8: The 24-Hour Rule

**Application**: Wait 24 hours between drafting and editing.

Cognitive refresh reveals:
- Unclear passages you thought were clear
- Redundancies you missed
- Missing transitions you assumed were there

## Common Revision Mistakes

### Mistake 1: Editing While Drafting

**Problem**: Interrupts creative flow, wastes time on text you'll delete
**Fix**: Draft first, edit later (separate sessions)

### Mistake 2: Starting with Grammar

**Problem**: You'll fix sentences you later delete
**Fix**: Work developmental → line → copy → proof

### Mistake 3: Over-Reliance on Tools

**Problem**: Tools don't understand context or meaning
**Fix**: Use tools for detection, not decision-making

### Mistake 4: Accepting All Suggestions

**Problem**: Not every "issue" is actually a problem
**Fix**: Evaluate each suggestion against context and purpose

### Mistake 5: Ignoring Reader Feedback

**Problem**: Authors can't see their own blind spots
**Fix**: Seek external feedback; it correlates with improvement

### Mistake 6: Single-Pass Revision

**Problem**: Different issues require different attention
**Fix**: Multiple passes, each with focused purpose

## Quantified Improvement Targets

**Based on research synthesis, effective revision should achieve:**

| Metric | Target |
|--------|--------|
| Word reduction | 10-30% from first to final draft |
| Average sentence length | 15-20 words |
| Maximum sentence length | 25 words |
| Passive voice | <10% of sentences |
| Adverbs (qualifiers) | Reduce by 50-70% |
| Multi-syllable words | Reduce by 20-30% where possible |
| Readability (Flesch) | 60-70 for general audience |

## Revision Workflow Summary

### Phase 1: Macro (30-40% of time)
- Structure and organization
- Core message clarity
- Information hierarchy

### Phase 2: Clarity (25-35% of time)
- Sentence simplification
- Active voice conversion
- Jargon elimination

### Phase 3: Conciseness (15-20% of time)
- Word elimination
- Phrase simplification
- Redundancy removal

### Phase 4: Polish (10-15% of time)
- Grammar and punctuation
- Consistency check
- Final proofreading
