# Bad CLAUDE.md Example

This example shows common anti-patterns to avoid.

```markdown
# Project Documentation

This is a React project.

## Setup

Run npm install.

## Code Style

- Use 2 spaces for indentation
- Use single quotes for strings
- Always add semicolons
- Use camelCase for variables
- Use PascalCase for components
- Maximum line length is 80 characters
- Import React components first, then utilities
- Sort imports alphabetically
- Use arrow functions
- Destructure props
- Use const over let
- Never use var

## API Endpoints

POST /api/users
Request:
{
  "name": "string",
  "email": "string",
  "password": "string"
}
Response:
{
  "id": 1,
  "name": "John",
  "email": "john@example.com",
  "createdAt": "2024-01-01T00:00:00Z"
}

GET /api/users/:id
...

[50+ more lines of API documentation]

## Database Schema

CREATE TABLE users (
  id SERIAL PRIMARY KEY,
  name VARCHAR(255) NOT NULL,
  email VARCHAR(255) UNIQUE NOT NULL,
  ...
);

[100+ more lines of SQL]

## Testing

Run tests with npm test.

## Deployment

Push to main to deploy.
```

## Problems with This Example

| Problem | Why It's Bad | Fix |
|---------|--------------|-----|
| **Styling rules** | Linters handle this better; wastes tokens | Move to `.eslintrc` |
| **API documentation** | Becomes stale; too detailed | Link to `/docs/api.md` or OpenAPI spec |
| **SQL schemas** | Duplicates source of truth | Reference migration files |
| **No emphasis** | All rules have equal weight | Use CRITICAL/IMPORTANT |
| **No WHY** | Missing purpose and context | Add "Why This Exists" section |
| **Vague commands** | "Run npm install" lacks context | Add descriptions for each command |
| **Too long** | 200+ lines dilutes effectiveness | Keep under 100 lines |
| **Generic** | Could apply to any React project | Add project-specific guidance |

## Key Takeaway

A CLAUDE.md should be a **strategic document** that tells Claude what makes THIS project unique, not a dumping ground for all documentation.
