# CLAUDE.md Quality Checklist

Use this checklist to validate any CLAUDE.md file.

## Golden Rule

Para cada línea: *"¿Eliminar esto causaría que Claude cometa errores?"*
Si no → eliminalo.

> "Think of CLAUDE.md as the 'unwritten knowledge' in your codebase"

---

## Structure Checklist

- [ ] **Under 200 lines** (ideal: ~100 lines)
- [ ] **Passes Golden Rule** (each line prevents mistakes)
- [ ] **Has Repository Overview** (1 paragraph, tech stack, purpose)
- [ ] **Has Why This Exists** (problem solved, target users)
- [ ] **Has Quick Start & Commands** (with descriptions)
- [ ] **Has Key Development Rules** (with emphasis)
- [ ] **Has References** (links to detailed docs)

## Content Checklist

- [ ] **No code snippets** (use file references instead)
- [ ] **No styling rules** (belongs in linter config)
- [ ] **No API documentation** (link to API docs)
- [ ] **No database schemas** (reference migration files)
- [ ] **No domain-specific knowledge** (move to skills)
- [ ] **Critical rules use CRITICAL/IMPORTANT** emphasis
- [ ] **Commands have descriptions** (`npm test # Run unit tests`)
- [ ] **Project-specific guidance** (not generic advice)

## Content Triage

Before adding content, ask:

| Question | Answer |
|----------|--------|
| Does it apply to ALL tasks? | → CLAUDE.md |
| Only certain task types? | → Create a skill |
| Changes frequently? | → Link to external docs |

## Emphasis Guide

Use these markers for important rules:

```markdown
- **CRITICAL**: Rules that must NEVER be violated (security, data loss)
- **IMPORTANT**: Rules that should always be followed (quality, consistency)
- **YOU MUST**: Mandatory actions for specific scenarios
- **NEVER**: Absolute prohibitions
- **ALWAYS**: Required behaviors
```

## Common Issues

| Issue | Detection | Fix |
|-------|-----------|-----|
| Too long | > 200 lines | Move details to /docs/ or skills |
| No emphasis | All rules plain text | Add CRITICAL/IMPORTANT |
| Stale content | Code snippets, schemas | Use file references |
| Missing WHY | No purpose section | Add business context |
| Generic | Could apply anywhere | Add project specifics |
| Domain bloat | Task-specific knowledge | Extract to skills |

## Quick Audit Commands

```bash
# Count lines
wc -l CLAUDE.md

# Check for code blocks (potential snippets)
grep -c '```' CLAUDE.md

# Check for emphasis markers
grep -E 'CRITICAL|IMPORTANT|NEVER|ALWAYS' CLAUDE.md

# Check for file references
grep -E '@|file:|/docs/' CLAUDE.md

# Check for @import usage
grep -E '^@|See @' CLAUDE.md
```

## Scoring Guide

| Score | Criteria |
|-------|----------|
| A | All checklist items pass, < 100 lines, passes Golden Rule |
| B | Most items pass, < 150 lines |
| C | Some issues, < 200 lines |
| D | Multiple issues, > 200 lines |
| F | Major issues, missing key sections, or domain bloat |
